export default class MovieClipManager {
   
    static _instance: MovieClipManager;
    public static get instance() {
        return MovieClipManager._instance || (MovieClipManager._instance = new MovieClipManager())
    }

    public movieClipPool:any[] = [];
    // 影片剪辑的配置属性
    public movieClipNamePool:any[] = [
        {name:'eFishLv1', dataName:'eFishLv1', num:30},
        {name:'eFishLv2', dataName:'eFishLv2', num:30},
        {name:'eFishLv3', dataName:'eFishLv3', num:30},
        {name:'eFishLv4', dataName:'eFishLv4', num:30},
        {name:'eFishLv5', dataName:'eFishLv5', num:30},
        {name:'eFishLv6', dataName:'eFishLv6', num:30},
        {name:'eFishLv7', dataName:'eFishLv7', num:30},
        {name:'eFishLv8', dataName:'eFishLv8', num:30},
        {name:'eFishLv9', dataName:'eFishLv9', num:30},
        {name:'eFishLv10', dataName:'eFishLv10', num:30},
        {name:'effect', dataName:'effect', num:1}
    ];

    

    // 初始化
    public async init(){
       await this.initMovieClip().then(()=>{
        console.log('mc初始化完毕')
       });
    }

    // 初始化影片剪辑
    private async initMovieClip(){
        for(let m = 0; m < this.movieClipNamePool.length; m++){
            await this.ayncLoad2Mc(`${this.movieClipNamePool[m].name}_json`);   
        }
    }

    // 异步加载动画资源
    private async ayncLoad2Mc(resname : string){
        await RES.getResAsync(resname,this.onLoad.bind(this),this);
    }

    // 加载完的回调
    private async onLoad(data: any,key: string){
        let scope = this;
        for(let m = 0; m < scope.movieClipNamePool.length; m++){
            if(key == `${scope.movieClipNamePool[m].name}_json`) {
                await scope.ayncLoad2Mc(`${scope.movieClipNamePool[m].name}_png`);
            }else if(key == `${scope.movieClipNamePool[m].name}_png`){
                for(let i = 0; i < scope.movieClipNamePool[m].num; i++){
                    let data2mc = RES.getRes(`${scope.movieClipNamePool[m].name}_json`);
                    let texture2mc = RES.getRes(`${scope.movieClipNamePool[m].name}_png`);
                    let mcFactory : egret.MovieClipDataFactory = new egret.MovieClipDataFactory(data2mc,texture2mc);
                    let mc:egret.MovieClip = new egret.MovieClip(mcFactory.generateMovieClipData(`${scope.movieClipNamePool[m].dataName}`));
                    mc.name = `${scope.movieClipNamePool[m].name}_${i}`;
                    scope.movieClipPool.push(mc);
                }
            }
        }
    }

    // 获取单个影片剪辑
    public getMovieClipByName(name:string):any{
        for(let mc = 0; mc < this.movieClipPool.length; mc++){
            if(this.movieClipPool[mc].name == name){
                return this.movieClipPool[mc];
            }
        }
    }

}