import { getSkinPath } from "../utils";

export default class ComponentBase extends eui.Component {
    protected data: any;
    constructor(data?) {
        super();
        this.data = data ? data : {};
        this.skinName = getSkinPath(this.skinKey);
        if (this.skin) {
            this.onSkinComplete();
        } else {
            this.addEventListener(egret.Event.COMPLETE, this.onSkinComplete, this);
        }
    }

    protected initEvents() { }

    protected removeEvents() { }

    start(data?) {

    }

    protected get skinKey() { return null }

    protected onSkinComplete() {
        this.initEvents();
    }

    destroy() {
        this.removeEvents();
    }

}