import { DataManager } from './../libs/tw/manager/DataManager';
import MainBase from "../libs/tl/MainBase";
import { NetManager } from "../libs/tw/manager/NetManager";
import Alert from "./alert/Alert";
import PanelCtrl from "./ctrls/panelCtrl";
import SceneCtrl from "./ctrls/sceneCtrl";
import OptionsPanel from "./optionsPanel/OptionsPanel";
import RulePanel from "./rulePanel/RulePanel";
import ExStartScene from "./startScene/ExStartScene";
import { ModuleTypes } from "./types/sceneTypes";
import PrizePanel from "./prizePanel/PrizePanel";
import NoPrizePanel from "./prizePanel/NoPrizePanel";
import RankPanel from "./rankPanel/RankPanel";
import showAlertPanel from "./ctrls/showAlertPanel";
import PlayScene from "./playScene/PlayScene";
import GameEndWaitingScene from "./gameEnd/gameEndWaitingScene";
import GameEndScene from "./gameEnd/gameEndScene";
import Msg from "./alert/Msg";
import GameConst from './GameConst';

class Main extends MainBase {
    protected registerModules() {
        // 注册所有Panel
        PanelCtrl.instance.registerClass(ModuleTypes.ALERT_PANEL, Alert);
        PanelCtrl.instance.registerClass(ModuleTypes.MSG_PANEL, Msg);
        PanelCtrl.instance.registerClass(ModuleTypes.RULE_PANEL, RulePanel);
        PanelCtrl.instance.registerClass(ModuleTypes.RANK_PANEL, RankPanel);
        PanelCtrl.instance.registerClass(ModuleTypes.OPTIONS_PANEL, OptionsPanel);
        PanelCtrl.instance.registerClass(ModuleTypes.PRIZE_PANEL, PrizePanel);
        PanelCtrl.instance.registerClass(ModuleTypes.NOPRIZE_PANEL, NoPrizePanel);

        // 注册所有Scene
        SceneCtrl.instance.registerClass(ModuleTypes.START_SCENE, ExStartScene);
        SceneCtrl.instance.registerClass(ModuleTypes.PLAY_SCENE, PlayScene);
        SceneCtrl.instance.registerClass(ModuleTypes.GAMEENDWAITING_SCENE, GameEndWaitingScene);
        SceneCtrl.instance.registerClass(ModuleTypes.GAMEEND_SCENE, GameEndScene);
        NetManager.ins.onNotSuccess=(msg)=>{
            showAlertPanel(msg)
        }
    }

    // 获取数据
    protected getData() {
        super.getData();
        
    }

    // 创建游戏场景
    protected createGameScene() {
        super.createGameScene();
        setTimeout(() => {
            GameConst.stage = this.stage;    
            console.log(GameConst.stage.width,GameConst.stage.height)
        }, 100);
        
        SceneCtrl.instance.change(ModuleTypes.START_SCENE);
    }


    /**
     * 资源组加载出错
     */
    protected onResourceLoadError(event:RES.ResourceEvent):void {
        this.trace("preload组加载失败");
        //忽略加载失败的项目
        this.onResourceLoadComplete(event);
    }
    
}

window['Main'] = Main;

egret.runEgret({
    renderMode: "webgl", audioType: 0, calculateCanvasScaleFactor: function (context:any) {
        var backingStore = context.backingStorePixelRatio ||
            context.webkitBackingStorePixelRatio ||
            context.mozBackingStorePixelRatio ||
            context.msBackingStorePixelRatio ||
            context.oBackingStorePixelRatio ||
            context.backingStorePixelRatio || 1;
        return (window.devicePixelRatio || 1) / backingStore;
    }
});