import { TimeFormat } from "../enum/TimeFormat";
export class GTime {
    /**
     * 获取当前时间戳
     * @returns {number}
     */
    public static getTimestamp(): number {
        return new Date().getTime();
    }

    /**
     * 传入秒数返回带格式的时间
     * @param time 单位秒
     * @param type 枚举类型CountDownType
     * @param dibit 是否双位
     */
    public static formatTime(time: number, type: string = TimeFormat.HMS, dibit = false, suffixs = ['d', 'h', 'm', 's']): string {
        let countdown = this.getCountDown(time, type, dibit);
        countdown = countdown.map((val, index) => `${val < 10 ? '0' + val : val}${suffixs[index]}`);
        return countdown.join('');
    }

    /**
     * 倒计时
     * @param time 单位秒
     * @param type 枚举类型CountDownType
     * @param dibit 是否双位
     */
    public static getCountDown(time: number, type: string = TimeFormat.HMS, dibit = false): any[] {
        let result: any[] = [];
        if (type.indexOf('s') !== -1) {
            result.push(time % 60);
        }

        if (type.indexOf('m') !== -1) {
            result.unshift(Math.floor((time % 3600) / 60));
        }

        if (type.indexOf('h') >= 0) {
            if (type == TimeFormat.HMS) {
                result.unshift(Math.floor(time / 3600));
            }
            else {
                result.unshift(Math.floor((time % 86400) / 3600));
            }
        }

        if (type.indexOf('d') >= 0) {
            result.unshift(Math.floor(time / 86400));
        }

        if (dibit)
            result = result.map((ele) => {
                return ele < 10 ? `0${ele}` : ele;
            })
        return result;
    }
}