import Panel from "../views/Panel";
import { showToast } from "../comm/UtilsConst";
import { G_GetHomeDataByKey, HOME } from "../Scenes/Home";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { GDispatcher } from "../../libs/tc/util/GDispatcher";
import Tween = egret.Tween;

export default class ExchangeBuyPanel extends Panel {
    public closeBtn: eui.Button;
    public btn: eui.Image;
    public titleImg: eui.Image;
    public title: eui.Label;
    public introduce: eui.Label;
    public price: eui.Label;

    public get skinKey() {
        return 'ExchangeBuyPanel'
    }

    public get groupName() {
        return 'exchange'
    }

    constructor(data?) {
        super(data);
    }

    onShowAnim() {
        // const canvasH = 750 / window.innerWidth * window.innerHeight;
        Tween.get(this).set({alpha: 0}).to({alpha: 1}, 233, egret.Ease.quadInOut);
    }

    protected getTapEvts(): any[] {
        return super.getTapEvts().concat([
            [this.btn, this.onTap, this],
        ]);
    }

    private onTap() {
        // 欢趣豆不足
        if(G_GetHomeDataByKey(HOME.GOLD) < this.data.price) {
            showToast('啊哦，欢趣豆不足，快去攒豆吧');
            return;
        }
        // 无库存
        if(this.data.stock <= 0) {
            showToast('啊哦，道具没有啦，晚点再来兑换吧');
            return;
        }

        this.btn.touchEnabled = false;
        // 预扣积分
        this.creditsCost().then((ticket) => {
            // 兑换商品
            NetManager.ins.propExchange((success, res) => {
                this.btn.touchEnabled = true;
                if(!success) {
                    showToast('啊哦...目前无法兑换哦');
                    return;
                }
                showToast('兑换成功，可返回农场使用');
                GDispatcher.dispatchEvent('shopUpdate');
                this.onTouchClose();
            }, this.data.spId, ticket, 1);
        }).catch(() => {
            this.btn.touchEnabled = true;
            showToast('啊哦...目前无法兑换哦');
        })
    }

    private creditsCost() {
        return new Promise((resolve, reject) => {
            NetManager.ins.creditsCost((success, res) => {
                if(!success) {
                    reject();
                    return;
                }
                const ticket = res.data;
                // 轮询扣积分状态
                NetManager.ins.queryStatus((success, res) => {
                    if(!success || res.data != 1) {
                        reject();
                        return;
                    }
                    resolve(ticket);
                }, ticket, (res) => {
                    return res.data == 0;
                });
            }, 'join_7', 'join', this.data.price, 'act_name');
        })
    }

    protected start() {
        super.start();
        this.initUI();

    }

    private initUI(): void {
        this.y = 750 / window.innerWidth * window.innerHeight * 0.2;
        this.title.text = this.data.title;
        this.titleImg.source = `shop_buy_${this.data.name}_png`;
        this.price.text = `所需欢趣豆：${this.data.price}`;
        this.introduce.text = `功能介绍：${this.data.introduce}`;
    }

    destroy() {
        super.destroy();
    }

}
