import TimeProgressBar from "./TimeProgressBar";
import { MainIns } from "./MainScene";

export default class ProgressMgr {

    private progressBars = {};

    constructor() {

    }

    public addProgress(data) {
        let {index, title, label, sTime, nTime, eTime} = data;
        let progressBar = new TimeProgressBar(index, title, label, sTime, nTime, eTime);
        progressBar.x = 88;
        progressBar.y = 123;
        MainIns().gameLayer.addChildAt(progressBar, 80);
        this.progressBars[index] = progressBar;

        return progressBar;
    }

    public removeProgress(index) {
        if(this.progressBars[index]) {
            this.progressBars[index].destroy();
            this.progressBars[index].parent.removeChild(this.progressBars[index]);
            this.progressBars[index] = null;
            delete this.progressBars[index];
        }
    }

    public destroy() {
        for(let k in this.progressBars) {
            this.progressBars[k].destroy();
            this.removeProgress(k);
        }
        this.progressBars = {};
    }
}