"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var utils_1 = require("../../../utils");
var MainScene_1 = require("../MainScene");
var NetManager_1 = require("../../../../libs/tw/manager/NetManager");
var UtilsConst_1 = require("../../../comm/UtilsConst");
var LandMgr_1 = require("../LandMgr");
var MSceneEnum_1 = require("../MSceneEnum");
var Home_1 = require("../../Home");
// 触发Option隐藏
var M_HideOption = function () {
    MainScene_1.MainDispatcher.dispatchEvent(MSceneEnum_1.default.HIDE_OPTION);
};
exports.M_HideOption = M_HideOption;
// 显示Option
var M_ShowOption = function (data) {
    MainScene_1.MainDispatcher.dispatchEvent(MSceneEnum_1.default.SHOW_OPTION, data);
};
exports.M_ShowOption = M_ShowOption;
/**
 * 操作面板
 */
var OptionPanel = (function (_super) {
    __extends(OptionPanel, _super);
    ////////////////////// 单例 //////////////////////
    function OptionPanel(data) {
        var _this = _super.call(this) || this;
        _this.data = null;
        _this.skinName = utils_1.getSkinPath('Objs/OptionPanel');
        _this.data = data || null;
        _this.initEvents();
        _this.initUI();
        return _this;
    }
    OptionPanel.getInstance = function (data) {
        return OptionPanel._instance || (OptionPanel._instance = new OptionPanel(data));
    };
    OptionPanel.destroy = function () {
        this._instance.removeEvents();
        this._instance = null;
    };
    OptionPanel.prototype.initEvents = function () {
        var _this = this;
        [this.wheatBtn, this.chickBtn, this.cattleBtn, this.cornBtn].forEach(function (v) {
            v.addEventListener(egret.TouchEvent.TOUCH_TAP, _this.onTap, _this);
        });
        MainScene_1.MainDispatcher.addEvent(MSceneEnum_1.default.SHOW_OPTION, this.showOption, this);
        MainScene_1.MainDispatcher.addEvent(MSceneEnum_1.default.HIDE_OPTION, this.hideOption, this);
    };
    OptionPanel.prototype.removeEvents = function () {
        var _this = this;
        [this.wheatBtn, this.chickBtn, this.cattleBtn, this.cornBtn].forEach(function (v) {
            v.removeEventListener(egret.TouchEvent.TOUCH_TAP, _this.onTap, _this);
        });
        MainScene_1.MainDispatcher.removeEvent(MSceneEnum_1.default.SHOW_OPTION, this.showOption, this);
        MainScene_1.MainDispatcher.removeEvent(MSceneEnum_1.default.HIDE_OPTION, this.hideOption, this);
    };
    OptionPanel.prototype.showOption = function (data) {
        console.log(data);
        this.data = data;
        M_HideOption(); // 先触发隐藏，保证地块正常显示
        egret.Tween.removeTweens(this);
        // if(this.visible){
        //     return;
        // }
        this.touchEnabled = true;
        this.touchChildren = true;
        // this.x = data.pos.x + 190;
        // this.y = data.pos.y + 90 - (MainIns().gameLayer.height - MainIns().group.height) / 2;
        // egret.Tween.removeTweens(this);
        this.alpha = 1;
        if (this.visible) {
            return;
        }
        this.visible = true;
        egret.Tween.get(this).set({ alpha: 0 }).to({ alpha: 1 }, 170);
        // egret.Tween.get(this).set({scaleX: 0, scaleY: 0}).to({scaleX: 1, scaleY: 1}, 500, egret.Ease.backOut);
    };
    OptionPanel.prototype.hideOption = function () {
        var _this = this;
        if (!this.visible) {
            return;
        }
        this.touchEnabled = false;
        this.touchChildren = false;
        egret.Tween.removeTweens(this);
        egret.Tween.get(this).to({ alpha: 0 }, 170).call(function () {
            _this.visible = false;
        });
        // egret.Tween.get(this).to({scaleX: 0, scaleY: 0}, 500, egret.Ease.quartInOut).call(() => {
        //     this.visible = false;
        // })
    };
    /// TODO 定义详细的操作
    OptionPanel.prototype.onTap = function (e) {
        var _this = this;
        var target = e.target;
        UtilsConst_1.btnDelay(target);
        var petId;
        switch (target) {
            case this.chickBtn:// 鸡
                petId = 1;
                break;
            case this.wheatBtn:// 小麦
                petId = 2;
                break;
            case this.cornBtn:// 玉米
                petId = 3;
                break;
            case this.cattleBtn:// 牛
                petId = 4;
                break;
            default:
                break;
        }
        // 0s（100%,100%）-0.1s(120%,120%)-0.2s(100%,100%)
        egret.Tween.get(target).to({ scaleX: 1.2, scaleY: 1.2 }, 100, egret.Ease.quadIn)
            .to({ scaleX: 1, scaleY: 1 }, 100, egret.Ease.quadOut).call(function () {
            M_HideOption();
            console.log(_this.data.index, petId);
            MainScene_1.M_SetGameLayerUpdate(false);
            NetManager_1.NetManager.ins.doPlant(function (success) {
                if (!success) {
                    MainScene_1.M_SetGameLayerUpdate(true);
                    return;
                }
                LandMgr_1.M_Plant({ landId: _this.data.index, petId: petId });
                Home_1.G_JudgeMedalPanel();
            }, _this.data.index, petId);
        });
    };
    OptionPanel.prototype.initUI = function () {
        this.visible = false;
        this.x = 170 + 190;
        this.y = 669 + 50 - (MainScene_1.MainIns().gameLayer.height - MainScene_1.MainIns().group.height) / 2;
        this.anchorOffsetX = this.width / 2;
        this.anchorOffsetY = this.height;
    };
    ////////////////////// 单例 //////////////////////
    OptionPanel._instance = null;
    return OptionPanel;
}(eui.Component));
exports.default = OptionPanel;
__reflect(OptionPanel.prototype, "\"/Users/haiyoucuv/Documents/Web/\u5DE5\u884C\u5361\u4E2D\u5FC3--\u6B22\u8DA3\u5E84\u56ED\u6D3B\u52A8/JoyousManor/egret/src/Scenes/MainScene/Objs/OptionPanel\".OptionPanel");
//# sourceMappingURL=OptionPanel.js.map