import { IStatusData } from './IStatusData';
import { Data } from "../../Data";

export class GetSummerInfoData extends Data {
    /**
     * 用户ID
     */
    public consumerId: number;

    /**
     * 累计成绩
     */
    public totalScore: number;

    /**
     * 最佳成绩
     */
    public maxScore: number;

    /**
     * 游戏状态
     */
    public status: IStatusData;

    public update(result: any): void {
        if (!result) {
            return;
        }
        super.update(result);
        let data;
        if(result.data) {
            if(result.data.rsp) {
                data = result.data.rsp;
            } else {
                data = result.data;
            }
        }
        this.consumerId = data.consumerId;
        this.totalScore = data.totalScore;
        this.maxScore = data.maxScore;
        this.status = data.status;
    }
}