import { getResPath } from "../utils";

export default class Box extends egret.Sprite {
    private _type: string;
    constructor(type) {
        super();
        this._type = type;
    }

    async createBg() {
        let url = getResPath() + `resource/assets/startScene/${this._type}.png`;
        return new Promise((resolve) => {
            RES.getResByUrl(url, (picData) => {
                const pic = new egret.Bitmap(picData);
                this.addChild(pic);
                this.anchorOffsetX = picData.textureWidth / 2;
                this.anchorOffsetY = picData.textureHeight / 2;
                resolve(pic)
            }, this, RES.ResourceItem.TYPE_IMAGE);
        });
    }

    get type() { return this._type }

    static getBoxList() {
        const list = [];
        for (const key in window['boxmap']) {
            if (window['boxmap'].hasOwnProperty(key)) {
                const element = window['boxmap'][key];
                list.push(key);
            }
        }
        return list;
    }
}