import { Decorator } from "../Decorator/Decorator";
import Panel from "../views/Panel";
import MItem from "../components/MItem";
import MButton from "../MUI/MButton";
import Net from "../Global/Net";
import { MConfigs } from "../Global/MConfigs";
import { NetUtils } from "../Global/NetUtils";
import { MConst } from "../Global/MConst";
import { Buried } from "../../libs/tw/util/Buried";

interface ItemData {
    index: number,
    content: string,
    url: string,
    finishFlag: boolean,
    taskCode: string,
    context: TaskPanel
}

@Decorator.ClassName("TaskPanel")
export default class TaskPanel extends Panel {
    public dataGroup: eui.DataGroup;
    public btnClose: MButton;

    onCompleteTask: () => void;

    onSkinComplete() {
        super.onSkinComplete();
        this.btnClose.onTap(this, () => this.hidePanel());

        this.dataGroup.itemRenderer = class extends MItem { //Item
            public labelNum: eui.Label;
            public labelContent: eui.Label;
            public btnDo: MButton;
            data: ItemData;

            onSkinComplete() {
                Buried.doShowBuried(6 + this.data.index);
                this.btnDo.onOnceTap(this, (resume) => {
                    if (this.data.finishFlag == false) {
                        const timestamp = NetUtils.getTimestamp();
                        Net.sendPost(Net.Url.taskComplete, {
                            taskCode: this.data.taskCode,
                            timestamp: timestamp,
                            token: NetUtils.md5(this.data.taskCode + timestamp.toString() + MConst.Md5ConstStr)
                        }, () => {
                            this.data.context.refresh();
                            gotoUrl(this.data.url);
                        }, () => { resume() });
                    } else {
                        gotoUrl(this.data.url);
                    }
                    Buried.doClickBuried(6 + this.data.index);
                });
            }

            dataChanged() {
                this.labelNum.text = "任务" + this.data.index;
                this.labelContent.text = this.data.content;
                this.btnDo.label = this.data.finishFlag == false ? "0/1" : "1/1";
            }
        }

        this.refresh();
    }

    public refresh() {
        Net.sendGet(Net.Url.taskData, undefined, (res) => {
            const taskList = res.data.taskList as { taskCode: string, finishFlag: boolean }[]

            let arr: ItemData[] = [];
            for (let i = 0; i < taskList.length; i++) {
                const config = MConfigs.task[taskList[i].taskCode];
                if (typeof config == "undefined") {
                    console.error("task config error");
                    continue;
                }
                arr.push({
                    index: i + 1,
                    content: config.content,
                    taskCode: config.taskCode,
                    finishFlag: taskList[i].finishFlag,
                    context: this,
                    url: config.url
                });
            }
            this.dataGroup.dataProvider = new eui.ArrayCollection(arr);
        }, () => { this.hidePanel() });
        this.onCompleteTask && this.onCompleteTask();
    }
}

function gotoUrl(url: string) {
    let options = {
        url: url
    };
    if (url.indexOf("https") === 0) {
        options["tpl"] = "webview";
    }
    window["aladdin"].navigator.forward(options);
}