import MItem from "../components/MItem";
import { MUtils } from "../Global/MUtils";

export default class SignInItem extends MItem {
    public groupScoreCard: eui.Group;
    public scoreCard100: eui.Group;
    public scoreCard500: eui.Group;
    public groupCoin: eui.Group;
    public imgSigned: eui.Image;
    public imgRevive: eui.Image;
    public signedMask: eui.Image;
    public labelDay: eui.Label;
    data: {
        cardId: string,
        isSigned: boolean,
        dayNum: number
    }

    onSkinComplete() {
        this.labelDay.text = `第${this.data.dayNum}天`;

        if (this.data.cardId) {
            this.groupScoreCard.visible = true;

            switch (this.data.cardId) {
                case "sp_1":
                    this.scoreCard100.visible = true;
                    break;
                case "sp_2":
                    this.scoreCard500.visible = true;
                    break;
                case "sp_3":
                    this.imgRevive.visible = true;
                    break;

                default:
                    break;
            }
        } else {
            this.groupCoin.visible = true;
        }

        if (this.data.isSigned) {
            this.signedMask.visible = true;
            this.imgSigned.visible = true;
        }
    }
}