// export const MConfigs: any = window;
export namespace MConfigs {
    export function updateConfig() {
        let mconfig = window["mconfig"];
        if (typeof mconfig != "object") return;

        Object.keys(mconfig).forEach(e => {
            MConfigs[e] = mconfig[e];
        });
    }

    export const size = [0.3125, 0.5357, 0.7321, 1];
    export const drop = {
        0: {
            type: "bullet",
            value: 1,
            textColor: 0x5dcefa,
            fileIndex: "0"
        },
        1: {
            type: "bullet",
            value: 2,
            textColor: 0x69e7fc,
            fileIndex: "1"
        },
        2: {
            type: "power",
            value: 30,
            textColor: 0xe83cf7,
            fileIndex: "2"
        },
        3: {
            type: "power",
            value: 20,
            textColor: 0xeb3924,
            fileIndex: "1"
        },
        4: {
            type: "power",
            value: 10,
            textColor: 0xfef552,
            fileIndex: "0"
        }
    }

    export const dropPool = {
        0: {
            num: 3,
            factor: {
                0: 40,
                1: 0,
                2: 0,
                3: 15,
                4: 50
            }
        },
        1: {
            num: 2,
            factor: {
                0: 40,
                1: 0,
                2: 5,
                3: 15,
                4: 50
            }
        },
        2: {
            num: 1,
            factor: {
                0: 40,
                1: 0,
                2: 5,
                3: 15,
                4: 50
            }
        }
    }

    export const props: {
        [key: string]: {
            id: string,
            name: string,
            img: string,
            color: number,
            disabledImg: string,
            index: number
        }
    } = {
        "sp_1": {
            index: 0,
            id: "sp_1",
            name: "1万分加分卡",
            img: "score_card_100_png",
            disabledImg: null,
            color: 0xf9b74b
        },
        "sp_2": {
            index: 1,
            id: "sp_2",
            name: "5万分加分卡",
            img: "score_card_500_png",
            disabledImg: null,
            color: 0xfe93df
        },
        "sp_3": {
            index: 2,
            id: "sp_11",
            name: "复活卡",
            img: "revive_card_png",
            disabledImg: "disabled_revive_card_png",
            color: 0x39c6e1
        }
    }

    export const selectPropsCountDown = 10;

    export const boomEffectColor = [
        0xe41014,
        0xff9600,
        0x0090ff,
        0x8aff00,
        0xffe720
    ]

    /**倒计时秒数 */
    export const countDown = 300;

    export const task: {
        [key: string]: {
            taskCode: string,
            content: string,
            url: string
        }
    } = {
        "1": {
            taskCode: "1",
            content: "去完成签到领金币\n获得1次游戏机会",
            url: "https://b.pingan.com.cn/mkt/koudai/koudaijin/index.html?Source=dxqrw&outersource=yqs_201908&channel_source=1"
        },
        "2":
        {
            taskCode: "2",
            content: "去做任务攒爱心\n获得1次游戏机会",
            url: "https://b.pingan.com.cn/mkt/koudai/kdgongyi/index.html?campaignid=201906006149&innerid=QMDXQ&channel_source=50"
        },
        "3": {
            taskCode: "3",
            content: "去浏览会员任务首页\n获得1次游戏机会",
            url: "https://b.pingan.com.cn/platform/member-system/index.html?innerid=daxingqiu"
        },
        "4":
        {
            taskCode: "4",
            content: "去邀请新用户参与活动\n获得1次游戏机会",
            url: "https://b.pingan.com.cn/mkt/youhui/1909/domgmyqh/index.shtml?campaignid=201909007503&innerid=KDAPP-GD-YX"
        },
        "5": {
            taskCode: "5",
            content: "去参与28会员日活动\n获得1次游戏机会",
            url: "https://b.pingan.com.cn/kuaizhan/page/brop/opt/20191021/h11456.html?campaignid=201910007967&source=daxingqiu"
        }
    }

    export const guide: {
        [key: number]: {
            mask: string,
            text: {
                str: string,
                offsetToMask: {
                    x: number,
                    y: number
                }
            },
            arrow: boolean
        }
    } = {
        0: {
            mask: "guide_mask_0_png",
            text: {
                str: "左右移动炮车进行射击和躲避",
                offsetToMask: {
                    x: -34,
                    y: 270
                }
            },
            arrow: true
        },
        1: {
            mask: "guide_mask_1_png",
            text: {
                str: "拾取金币可获得更多的炮弹输出和得分加成",
                offsetToMask: {
                    x: -55,
                    y: 394
                }
            },
            arrow: false
        },
    }

    export const difficultyFactor = 0.25;
    export const rewardRecordUrl = "http://activity.m.duibatest.com.cn/projectx/p98a3fa4c/f09ba186f.html";

    export const rule = "";
}