import { DataManager } from './../../libs/tw/manager/DataManager';
import { ModuleTypes } from './../types/sceneTypes';

import Scene from "../views/Scene";
import PanelCtrl from "../ctrls/panelCtrl";
import SceneCtrl from '../ctrls/sceneCtrl';
import { NetManager } from '../../libs/tw/manager/NetManager';
import Loading from '../loading/Loading';
import { Buried } from '../../libs/tw/util/Buried';
import { GCache } from '../../libs/tc/util/GCache';
import { FriendItemComponent } from '../components/FriendItemComponent';
export default class TeamScene extends Scene {

    public topCention:eui.Group;
    public frendCountText:eui.Label;
    public extraRateText:eui.Label;
    public backBtn:eui.Button;
    public addFrendBtn:eui.Button;
    public showListGroup:eui.Group;
    

    public mainbg:eui.Image;

    public get skinKey() { return 'TeamScene' }
    public get groupName() { return 'team_scene' }

    constructor(data?) {
        super(data);//95fcf3
    }

    initEvents() {
        super.initEvents();
        this.addFrendBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_addFrendBtn, this);
        this.backBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_backBtn, this);
    }

    removeEvents() {
        super.removeEvents();
        this.addFrendBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_addFrendBtn, this);
        this.backBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_backBtn, this);
    }


    onTap_addFrendBtn(){

    }

    onTap_backBtn(){

    }

    start(data?) {
        super.start(data);
        this.percentHeight = 100;
    }

    private bgtexture: egret.Texture;
    protected async preLoadRes() {
        //加载背景并设置背景图片
        this.bgtexture = await RES.getResAsync('team_bg_jpg');

        return new Promise(function (resolve, reject) {
            resolve();
        });
    }

    protected onSkinComplete(): void {
        super.onSkinComplete();

        this.mainbg.texture = this.bgtexture;

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    private onLoad(): void {
        this.initUI();
    }

    private initUI():void{
        let orgX = 41;
        let space = 10;
        let dataArr = DataManager.ins.shopYunjiData.data;
        for(let i = 0; i < 30; i++){
            let dname;
            let lock;
            if(!dataArr[i].lock){
                dname = 'dog_lv_' + (i + 1) + '_png';
                lock = false;
            }else{
                dname = 'dog' + i + '_png';
                lock = true;
            }
            let dItem = new FriendItemComponent();
            this.showListGroup.addChild(dItem);

            dItem.x = orgX;
            dItem.y = i * (162 + space);

        }
    }
    

}
