import MItem from "../MComponents/MItem";
import Net from "../Global/Net";
import { Decorator } from "../Decorator/Decorator";
import { ThroughSubmitData } from "../../../libs/tw/data/custom/throughSubmit/ThroughSubmitData";
import GameMgr from "../Mgr/GameMgr";
import MScroller from "./MScroller";
import MSceneCtrl from "../MCtrls/MSceneCtrl";
import { calculateReward } from "../Global/GUtils";
import { MUtils } from "../Global/MUtils";

@Decorator.Skin("RankList")
export default class RankList extends eui.Component implements Decorator.ISkin {
    public toggleWeekRank: eui.RadioButton;
    public toggleTotalRank: eui.RadioButton;
    public bg: eui.Image;
    public dataGroup: eui.List;
    public scroller: eui.Scroller;
    public toggleMore: eui.ToggleButton;
    public labelTip: eui.Label;

    private pageScroller: MScroller = null;

    onSkinComplete() {
        this.dataGroup.itemRenderer = RankItem;

        this.pageScroller = GameMgr.instance.pageScroller;

        let radioGroup = new eui.RadioButtonGroup();
        this.toggleWeekRank.group = radioGroup;
        this.toggleTotalRank.group = radioGroup;
        radioGroup.addEventListener(eui.UIEvent.CHANGE, (evt: eui.UIEvent) => {
            this.onToggle((evt.target as eui.RadioButtonGroup).selection);
        }, this);

        this.onToggle(this.toggleWeekRank);

        this.scroller.addEventListener(egret.TouchEvent.TOUCH_BEGIN, (event: egret.TouchEvent) => {
            GameMgr.instance.rankListTouchId = event.touchPointID;
        }, this);

        this.toggleMore.addEventListener(egret.Event.CHANGE, (evt: egret.Event) => {
            let target: eui.ToggleButton = evt.target;
            if (target.selected) {
                this.bg.height += 276;
                this.dataGroup.height += 276;
                MSceneCtrl.instance.curBg.height += 276;

                console.error(this.scroller.viewport.scrollV, this.scroller.viewport.contentHeight, this.scroller.height, this.scroller.viewport.contentHeight - this.scroller.height)

                if (this.scroller.viewport.contentHeight <= this.scroller.height) {
                    this.scroller.viewport.scrollV = 0;
                    return;
                }
                let offsetY = this.scroller.viewport.scrollV;
                let targetY = Math.min(offsetY, this.scroller.viewport.contentHeight - this.scroller.height);
                this.scroller.viewport.scrollV = targetY;
            } else {
                this.bg.height -= 276;
                this.dataGroup.height -= 276;
                MSceneCtrl.instance.curBg.height -= 276;
                GameMgr.instance.pageScroller.refreshPos();
            }
        }, this);
        /* this.toggleMore.onTap(this, () => {
            this.toggleMore.visible = false;

        }); */
    }

    private onToggle(toggle: eui.ToggleButton) {
        let param = {
            topN: 200
        };
        if (toggle === this.toggleWeekRank) {
            param["type"] = GameMgr.instance.weekType;
        } else if (toggle === this.toggleTotalRank) {
            param["type"] = GameMgr.instance.totalType;
        }

        let arr: DataType[] = [];
        Net.sendGet(Net.Url.RankList, param, (res) => {
            let ids: string[] = [];
            for (let i of res.data) {
                arr.push({
                    index: i.index,
                    count: i.score,
                    reward: calculateReward(i.score),
                    userId: i.userId
                });
                ids.push(i.userId);
            }

            if (ids.length <= 0) {
                this.labelTip.visible = false;
                this.dataGroup.dataProvider = new eui.ArrayCollection([]);
                return;
            }

            Net.sendGet(Net.Url.RankListData, {
                ids: ids.join(",")
            }, (res) => {
                let data = res.data;
                for (let i of arr) {
                    let d = data[i.userId];
                    if (typeof d != "undefined") {
                        i.code = d.userCode;
                        i.department = d.department;
                    } else {
                        console.error("rank list map error");
                    }
                }

                this.dataGroup.dataProvider = new eui.ArrayCollection(arr);
                this.labelTip.visible = false;
            });
        });
    }
}

interface DataType {
    index: number,
    department?: string,
    code?: string,
    count: number,
    reward: number,
    userId: number
}

class RankItem extends MItem {
    public imgSpRank: eui.Image;
    public labelRank: eui.Label;
    public labelBankName: eui.Label;
    public labelJobNnum: eui.Label;
    public labelReward: eui.Label;

    data: DataType;

    dataChanged() {
        this.labelRank.text = this.data.index.toString();
        if (this.data.index <= 3 && this.data.index >= 1) {
            this.imgSpRank.source = `rank_${this.data.index}_png`;
            this.labelRank.visible = false;
        } else {
            this.imgSpRank.source = "";
            this.labelRank.visible = true;
        }

        this.labelBankName.text = this.data.department;
        /* if (MUtils.getStringRealLength(this.data.department) > 8) {
            this.labelBankName.size = 17;
        } */
        this.labelJobNnum.text = this.data.code;
        this.labelReward.text = `已邀请${this.data.count}人奖励${this.data.reward}元`;
    }
}