import GameMgr from "../Mgr/GameMgr";
import { MConst } from "../Global/MConst";
import MSceneCtrl from "../MCtrls/MSceneCtrl";

export default class MScroller extends eui.Group {
    public mScrollerEnabled: boolean = true;
    private prePosY: number = 0;
    private gameMgr: GameMgr = null;
    private minY = 0;
    public realGameHeight: number = 0;

    public onMoved: (target: MScroller) => void;

    constructor() {
        super();
        this.touchEnabled = true;
        this.realGameHeight = (document.body.clientHeight / document.body.clientWidth) * MConst.DesignResolution.width;
        this.gameMgr = GameMgr.instance;
        this.addEventListener(egret.TouchEvent.TOUCH_BEGIN, this.onTouchBegin, this);
        this.addEventListener(egret.TouchEvent.TOUCH_MOVE, this.onTouchMove, this);
    }

    private onTouchBegin(event: egret.TouchEvent) {
        if (this.gameMgr.rankListTouchId == null) {
            this.prePosY = event.stageY;
        }
    }

    private onTouchMove(event: egret.TouchEvent) {
        if (this.gameMgr.rankListTouchId == null) {
            this.y += event.stageY - this.prePosY;
            this.y = Math.clamp(this.y, this.realGameHeight - MSceneCtrl.instance.gameHeight, 0);
            this.prePosY = event.stageY;

            this.onMoved && this.onMoved(this);
        }
    }

    refreshPos() {
        let minY = MSceneCtrl.instance.curBg.height - (document.body.clientHeight / document.body.clientWidth) * MConst.DesignResolution.width;
        // console.error(-minY, this.y);
        this.y = Math.max(-minY, this.y);
        this.onMoved && this.onMoved(this);
    }
}