import MScene from "../MViews/MScene";
import MButton from "../MUI/MButton";
import { Decorator } from "../Decorator/Decorator";
import RankList from "../UIComponent/RankList";
import MPanelCtrl from "../MCtrls/MPanelCtrl";
import InputNumPanel from "../Panel/InputNumPanel";
import Loading from "../../loading/Loading";
import MSceneCtrl from "../MCtrls/MSceneCtrl";
import RulePanel from "../Panel/RulePanel";

@Decorator.ClassName("StartScene")
export default class StartScene extends MScene {
    public btnJoin: MButton;
    public btnRule: eui.Button;
    public rankList: eui.Group;
    public bg: eui.Image;

    onSkinComplete() {
        super.onSkinComplete();
        MSceneCtrl.instance.curBg = this.bg;
        this.rankList.addChild(new RankList());
        this.btnJoin.onTap(this, () => {
            MPanelCtrl.instance.show(InputNumPanel);
        });
        this.btnRule.onTap(this, () => {
            MPanelCtrl.instance.show(RulePanel);
        });
    }
}
