import MScene from "../MViews/MScene";
import { Decorator } from "../Decorator/Decorator";
import MButton from "../MUI/MButton";
import MItem from "../MComponents/MItem";
import { MConfigs } from "../Global/MConfigs";
import MPanelCtrl from "../MCtrls/MPanelCtrl";
import GameMgr from "../Mgr/GameMgr";
import MBuried from "../Global/MBuried";
import RankList from "../UIComponent/RankList";
import MTextEditor from "../MUI/MTextEditor";
import { copy as copyToClipboard, shareJobNum, calculateReward, getShareUrl, shareActivity } from "../Global/GUtils";
import MSceneCtrl from "../MCtrls/MSceneCtrl";
import Net from "../Global/Net";
import ToastPanel from "../MComponents/MToastPanel";
import { NetUtils } from "../Global/NetUtils";
import RulePanel from "../Panel/RulePanel";

@Decorator.ClassName("MainScene")
@Decorator.OnUpdate
export default class MainScene extends MScene {
    public iconEdit: eui.Image;
    public labelBank: eui.Label;
    public textEditor: eui.EditableText;
    public btnCopy: MButton;
    public labelMonthInvite: eui.Label;
    public labelReward: eui.Label;
    public btnShare: MButton;
    public btnRule: eui.Button;
    public rankList: eui.Group;
    public testLabel: eui.Label;
    public groupShareTip: eui.Group;
    public bg: eui.Image;
    public imgShareTip: eui.Image;

    private jobNum: string = null;


    async onSkinComplete() {
        super.onSkinComplete();
        MSceneCtrl.instance.curBg = this.bg;
        this.btnRule.onTap(this, () => {
            MPanelCtrl.instance.show(RulePanel);
        });

        let res = (this.data && this.data.response) || (await NetUtils.getUserInfo());
        this.labelBank.text = `（${res.data.department}）`;
        this.labelMonthInvite.text = `上周累计邀请${res.data.weekCount}人`;
        this.labelReward.text = `总邀请${res.data.totalCount}人 预计可获得奖励${calculateReward(res.data.totalCount)}元`;
        this.textEditor.text = res.data.code;
        this.jobNum = res.data.code;

        this.rankList.addChild(new RankList());

        this.textEditor.touchEnabled = false;
        //输入框

        this.testLabel.text = this.textEditor.text;
        this.iconEdit.horizontalCenter = this.testLabel.width / 2 + 20;
        this.testLabel.addEventListener(egret.TouchEvent.TOUCH_BEGIN, () => {
            this.textEditor.setFocus();
        }, this);
        this.iconEdit.addEventListener(egret.TouchEvent.TOUCH_BEGIN, () => {
            this.textEditor.setFocus();
        }, this);
        this.textEditor.addEventListener(egret.Event.CHANGE, () => {
            this.testLabel.text = this.textEditor.text;
            this.iconEdit.horizontalCenter = this.testLabel.width / 2 + 20;
        }, this);
        this.textEditor.addEventListener(egret.FocusEvent.FOCUS_OUT, () => {
            if (this.textEditor.text == "") {
                ToastPanel.show("输入不能为空");
                this.textEditor.text = this.jobNum;
                this.testLabel.text = this.textEditor.text;
                this.iconEdit.horizontalCenter = this.testLabel.width / 2 + 20;
                return;
            }

            Net.sendGet(Net.Url.JobNum, {
                userCode: this.textEditor.text
            }, () => {
                // this.jobNum = res.data.code;
                MSceneCtrl.instance.change(MainScene);
            }, (res2) => {
                this.textEditor.text = this.jobNum;
                this.testLabel.text = this.textEditor.text;
                this.iconEdit.horizontalCenter = this.testLabel.width / 2 + 20;

                if (res2.code == "100202") {
                    ToastPanel.show("请正确输入员工工号，以K3系统为准");
                    return true;
                } else
                    return false;
            });
        }, this);

        this.btnCopy.onTap(this, () => {
            copyToClipboard(this.jobNum);
        });

        this.btnShare.visible = true;
        this.btnShare.y = Math.abs(GameMgr.instance.pageScroller.y) + GameMgr.instance.pageScroller.realGameHeight - 200;
        this.btnShare.onTap(this, () => {
            this.groupShareTip.visible = true;
            this.imgShareTip.y = 131 - GameMgr.instance.pageScroller.y;
            shareJobNum(this.jobNum);
            // window.open(getShareUrl(this.jobNum));
        });

        GameMgr.instance.pageScroller.onMoved = (target) => {
            this.btnShare.y = Math.abs(target.y) + target.realGameHeight - 200;
        };

        window["onShared"] = () => {
            this.groupShareTip.visible = false;
            shareActivity();
        }
    }

}