import MPanel from "../MViews/MPanel";
import { HtmlTextParser } from "../../../libs/tc/util/HtmlTextParser";
import MButton from "../MUI/MButton";
import Net from "../Global/Net";
import { MConfigs } from "../Global/MConfigs";
import GameMgr from "../Mgr/GameMgr";

export default class RulePanel extends MPanel {
    get skinKey() { return "RulePanel" }
    public text: eui.Label;
    public btnOk: MButton;
    public scroller: eui.Scroller;
    public btnClose: MButton;
    data: {
        msg: string
    }

    onSkinComplete() {
        super.onSkinComplete();
        this.text.textFlow = new HtmlTextParser().parse(MConfigs.rule);
        /* Net.sendGet(Net.Url.Rule, undefined, (res) => {
            this.text.textFlow = new HtmlTextParser().parse(res.data);
            // this.text.text = res.data;
        }); */
        this.btnClose.onTap(this, () => this.hidePanel());
        this.btnOk.onTap(this, () => this.hidePanel());

        this.scroller.addEventListener(egret.TouchEvent.TOUCH_BEGIN, (event: egret.TouchEvent) => {
            GameMgr.instance.rankListTouchId = event.touchPointID;
        }, this);
    }
}