import MPanel from "../MViews/MPanel";
import { Decorator } from "../Decorator/Decorator";
import MButton from "../MUI/MButton";
import ToastPanel from "../MComponents/MToastPanel";
import MSceneCtrl from "../MCtrls/MSceneCtrl";
import MainScene from "../Scene/MainScene";
import Net from "../Global/Net";

@Decorator.ClassName("InputNumPanel")
export default class InputNumPanel extends MPanel {
    public editor: eui.EditableText;
    public btnOk: MButton;
    public btnClose: MButton;


    onSkinComplete() {
        super.onSkinComplete();
        this.btnClose.onTap(this, () => {
            this.hidePanel();
        });
        this.btnOk.onOnceTap(this, (r) => {
            if (this.editor.text == "") {
                ToastPanel.show("输入不能为空");
                r();
                return;
            }

            Net.sendGet(Net.Url.JobNum, {
                userCode: this.editor.text
            }, () => {
                MSceneCtrl.instance.change(MainScene);
                this.hidePanel();
            }, (res2) => {
                r();
                if (res2.code == "100202") {
                    ToastPanel.show("请正确输入员工工号，以K3系统为准");
                    return true;
                } else
                    return false;
            });
        });
    }
}