import Pool, { PoolElement } from "../MComponents/Pool";
import GameObject from "../Game/GameObject";

/**内存池管理 */
export default abstract class PoolMgr<T extends PoolElement & egret.DisplayObjectContainer>{
    protected layer: egret.DisplayObjectContainer = null;
    private pool: Pool<T> = new class extends Pool<T>{
        private context: PoolMgr<T> = null;
        constructor(context: PoolMgr<T>) {
            super();
            this.context = context;
        }
        createElement(...args: any[]) {
            return this.context.createElement(args);
        }
    }(this);

    constructor(layer: egret.DisplayObjectContainer) {
        this.layer = layer;
    }

    create(...args: any[]): T {
        let element = this.pool.get(...args);
        this.layer.addChild(element);
        return element;
    }

    destroy(element: T) {
        this.pool.recycle(element);
    }

    abstract createElement(...args: any[]): T;
}