import { MConst } from "../Global/MConst";
import GameMgr from "../Mgr/GameMgr";
import MScroller from "../UIComponent/MScroller";

class Layers extends eui.Group {
    public sceneLayer: eui.Group = null;
    public popupLayer: eui.Group = null;
    public topLayer: eui.Group = new eui.Group();
    public toastLayer: eui.UILayer = new eui.UILayer();
    init(root: eui.UILayer) {
        let scroller = new MScroller();
        root.addChild(scroller);
        scroller.addChild(this);
        this.popupLayer = new eui.Group();
        this.popupLayer.width = MConst.DesignResolution.width;
        // this.popupLayer.height = MConst.DesignResolution.minHeight;
        this.sceneLayer = new eui.Group();
        this.sceneLayer.width = MConst.DesignResolution.width;
        // this.sceneLayer.height = MConst.DesignResolution.minHeight;
        this.addChild(this.sceneLayer);
        this.addChild(this.popupLayer);
        this.topLayer.width = MConst.DesignResolution.width;
        // this.topLayer.height = MConst.DesignResolution.minHeight;
        GameMgr.instance.pageScroller = scroller;

        this.stage.addEventListener(egret.TouchEvent.TOUCH_END, this.onTouchEnd, this);
        this.stage.addEventListener(egret.TouchEvent.TOUCH_CANCEL, this.onTouchEnd, this);

        root.addChild(this.toastLayer);
        root.addChild(this.topLayer);

        /* const minHeight = MConst.DesignResolution.minHeight;
        if (document.body.clientWidth / document.body.clientHeight > ((MConst.DesignResolution.width) / minHeight)) {
            let scroller = new eui.Scroller();
            root.addChild(scroller);
            scroller.viewport = this;
            scroller.bounces = false;
            scroller.addChild(this);
            this.popupLayer = new eui.Group();
            this.popupLayer.width = 750;
            this.popupLayer.height = minHeight;
            this.sceneLayer = new eui.Group();
            this.sceneLayer.width = 750
            this.sceneLayer.height = minHeight;
            this.addChild(this.sceneLayer);
            this.addChild(this.popupLayer);
        } else {
            root.addChild(this);
            this.popupLayer = new eui.UILayer();
            this.sceneLayer = new eui.Group();
            this.addChild(this.sceneLayer);
            this.addChild(this.popupLayer);
        }

        this.addChild(this.toastLayer);
        this.addChild(this.topLayer); */


        this.popupLayer.visible = false;
        this.topLayer.visible = false;
        this.toastLayer.touchEnabled = false;
    }

    private onTouchEnd(event: egret.TouchEvent) {
        if (event.touchPointID == GameMgr.instance.rankListTouchId) {
            GameMgr.instance.rankListTouchId = null;
        }
    }
}

const instance = new Layers();
export default instance