import Loading from "../../loading/Loading";
import IScene from "../MComponents/IScene";
import MScene from "../MViews/MScene";

export default class MSceneCtrl {
    public get parent(): eui.Group {
        return this._parent;
    }
    private _parent: eui.Group;
    private _currentScene: MScene;
    public curBg: eui.Image = null;

    static _instance: MSceneCtrl;
    static get instance() {
        return MSceneCtrl._instance || (MSceneCtrl._instance = new MSceneCtrl())
    }
    init(parent: eui.Group) {
        this._parent = parent;
    }

    get gameHeight() {
        return this._parent.height;
    }

    change<T extends MScene>(cls: any, data?: any): T {
        let scene: MScene = new cls(data);

        if (this._currentScene) {
            let preScene = this._currentScene;
            scene.visible = false;
            scene.onLoaded = () => {
                preScene.destroy();
                scene.visible = true;
            }
        }

        this._currentScene = scene;
        this._parent.addChild(scene);

        return scene as T;
    }
}