import { NetManager } from "../../../libs/tw/manager/NetManager";

export default class MBuried {
    private static appId: number | string;
    private static oaId: number | string;

    /**
     * 初始化
     */
    public static init(appId: number | string, oaId: number | string): void {
        MBuried.appId = appId;
        MBuried.oaId = oaId;
    }

    /**
     * 创建dpm埋点数据
     */
    public static createExposure(appIdParam: string | number, embedDomain = '//embedlog.duiba.com.cn') {
        return {
            dpm: MBuried.appId.toString() + `.110.${appIdParam}.1`,
            dcm: `202.${MBuried.oaId}.0.0`,
            appId: MBuried.appId.toString(),
            domain: embedDomain
        };
    }

    private static doBuried(appIdParam: string | number, netManager: NetManager, callback: string) {
        let data = MBuried.createExposure(appIdParam);
        netManager[callback](data);
    }

    public static doClickBuried(appIdParam: string | number) {
        MBuried.doBuried(appIdParam, NetManager.ins, "clickLog");
    }
    public static doShowBuried(appIdParam: string | number) {
        MBuried.doBuried(appIdParam, NetManager.ins, "showLog");
    }

}