import { NetUtils } from "./NetUtils";
import MSceneCtrl from "../MCtrls/MSceneCtrl";
import StartScene from "../Scene/StartScene";
import MainScene from "../Scene/MainScene";
import { MConfigs } from "./MConfigs";
import ToastPanel from "../MComponents/MToastPanel";

export const getResPath = () => window['resPath'] || '';
export const getSkinPath = (key: any) => `resource/skins/${key}Skin.exml`

let shareImg: HTMLElement = null;
export function setShareImg(imgUrl: string, rect: egret.Rectangle, visible: boolean = true) {
    shareImg = shareImg || document.getElementById('shareImg');
    shareImg.style.position = 'absolute';
    shareImg.style.display = 'block';
    shareImg.style.visibility = "visible";
    shareImg.style.opacity = visible ? "1" : "0";
    let scaler = document.body.clientWidth / 750;
    shareImg.style.width = (scaler * rect.width).toString() + "px";
    shareImg.style.height = (scaler * rect.height).toString() + "px";
    shareImg.style.left = (rect.x * scaler).toString() + "px";
    shareImg.style.top = (rect.y * scaler).toString() + "px";
    shareImg['src'] = imgUrl;
}
export function clearShareImg() {
    if (!shareImg) {
        console.log("shareImg is null");
        return;
    }

    shareImg.style.width = "0px";
    shareImg.style.height = "0px";
    shareImg.style.visibility = "hidden";
}

export function copy(str: string) {
    var save = function (e: any) {
        e.clipboardData.setData('text/plain', str);//下面会说到clipboardData对象
        e.preventDefault();//阻止默认行为
    }
    document.addEventListener('copy', save);
    document.execCommand("copy");//使文档处于可编辑状态，否则无效
    ToastPanel.show("复制成功");
}

export function getShareUrl(jobNum: string) {
    return MConfigs.share.url + "&jobNum=" + jobNum;
}


export function shareActivity() {
    let wx = window["wx"];
    let share = {
        title: "重庆银行营销精英挑战赛",
        desc: "您的好友邀请您参加重庆银行营销精英挑战赛，快来参与吧！",
        imgUrl: MConfigs.share.imgUrl
    }
    wx.onMenuShareTimeline({
        title: share.title,
        desc: share.desc,
        link:/*  MConfigs.activityUrl */window.location.href,
        imgUrl: share.imgUrl,
        success: function () {
        },
        cancel: function () {
        }
    });
    wx.onMenuShareAppMessage({
        title: share.title,
        desc: share.desc,
        link: /* MConfigs.activityUrl */window.location.href,
        imgUrl: share.imgUrl,
        success: function () {
        },
        cancel: function () {
        }
    });
}

export function shareJobNum(jobNum: string) {
    let wx = window["wx"];
    let share = MConfigs.share;
    wx.onMenuShareTimeline({
        title: share.title,
        desc: share.desc,
        link: getShareUrl(jobNum),
        imgUrl: share.imgUrl,
        success: function () {
            window["onShared"] && window["onShared"]();
        },
        cancel: function () {
            window["onShared"] && window["onShared"]();
        }
    });
    wx.onMenuShareAppMessage({
        title: share.title,
        desc: share.desc,
        link: getShareUrl(jobNum),
        imgUrl: share.imgUrl,
        success: function () {
            window["onShared"] && window["onShared"]();
        },
        cancel: function () {
            window["onShared"] && window["onShared"]();
        }
    });
}

export function calculateReward(count: number): number {
    let reward = 0;
    if (count >= 3) {
        reward += 10;
    }
    if (count >= 6) {
        reward += 20;
    }
    if (count < 20) {
        reward = reward;
    }
    else if (count >= 20 && count < 80) {
        reward += count * 5;
    } else if (count >= 80 && count < 120) {
        reward += count * 6;
    } else if (count >= 120 && count < 200) {
        reward += count * 7;
    } else {
        reward += count * 8;
    }

    reward = Math.min(4000, reward);

    return reward;
}

export function isWeiXin() {
    var ua = navigator.userAgent.toLowerCase();
    if (ua.match(/MicroMessenger/i)) {
        return true
    } else {
        return false
    }
}