"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = y[op[0] & 2 ? "return" : op[0] ? "throw" : "next"]) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [0, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var DataManager_1 = require("./../../libs/tw/manager/DataManager");
var sceneTypes_1 = require("./../types/sceneTypes");
var Scene_1 = require("../views/Scene");
var panelCtrl_1 = require("../ctrls/panelCtrl");
var sceneCtrl_1 = require("../ctrls/sceneCtrl");
var NetManager_1 = require("../../libs/tw/manager/NetManager");
var FriendItemComponent_1 = require("../components/FriendItemComponent");
var NetName_1 = require("../../libs/tw/enum/NetName");
var TeamScene = (function (_super) {
    __extends(TeamScene, _super);
    function TeamScene(data) {
        var _this = _super.call(this, data) || this;
        _this.Events = [];
        _this.dItems = [];
        _this.overTimes = [];
        return _this;
    }
    Object.defineProperty(TeamScene.prototype, "skinKey", {
        get: function () { return 'TeamScene'; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(TeamScene.prototype, "groupName", {
        get: function () { return 'team_scene'; },
        enumerable: true,
        configurable: true
    });
    TeamScene.prototype.initEvents = function () {
        _super.prototype.initEvents.call(this);
        this.addFrendBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_addFrendBtn, this);
        this.backBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_backBtn, this);
    };
    TeamScene.prototype.removeEvents = function () {
        _super.prototype.removeEvents.call(this);
        this.addFrendBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_addFrendBtn, this);
        this.backBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_backBtn, this);
        //删除子项事件
        this.clearList();
    };
    TeamScene.prototype.clearList = function () {
        var _this = this;
        clearInterval(this.Events["setTimes"]);
        this.dItems.forEach(function (data, i) {
            _this.showListGroup.removeChild(_this.dItems[i]);
        });
    };
    TeamScene.prototype.onTap_addFrendBtn = function () {
        panelCtrl_1.default.instance.btnDelay(this.backBtn);
        panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.SHARE2_PANEL);
    };
    TeamScene.prototype.onTap_backBtn = function () {
        panelCtrl_1.default.instance.btnDelay(this.backBtn);
        NetManager_1.NetManager.ins.getHome(function (succuss) {
            if (!succuss) {
                return;
            }
            sceneCtrl_1.default.instance.change(sceneTypes_1.ModuleTypes.MAIN_SCENE);
        }, this.getQueryString("dailyMark"), window["CFG"].activityId);
    };
    TeamScene.prototype.getQueryString = function (name) {
        var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)");
        var r = window.location.search.substr(1).match(reg);
        if (r != null)
            return unescape(r[2]);
        return null;
    };
    ;
    TeamScene.prototype.start = function (data) {
        _super.prototype.start.call(this, data);
        this.percentHeight = 100;
    };
    TeamScene.prototype.preLoadRes = function () {
        return __awaiter(this, void 0, void 0, function () {
            var _a;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        //加载背景并设置背景图片
                        _a = this;
                        return [4 /*yield*/, RES.getResAsync('team_bg_jpg')];
                    case 1:
                        //加载背景并设置背景图片
                        _a.bgtexture = _b.sent();
                        return [2 /*return*/, new Promise(function (resolve, reject) {
                                resolve();
                            })];
                }
            });
        });
    };
    TeamScene.prototype.onSkinComplete = function () {
        _super.prototype.onSkinComplete.call(this);
        this.mainbg.texture = this.bgtexture;
        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    };
    TeamScene.prototype.onLoad = function () {
        this.initUI();
    };
    TeamScene.prototype.initUI = function () {
        this.dItems = [];
        console.log(this.datas);
        this.clearList();
        this.resetList();
    };
    TeamScene.prototype.resetList = function () {
        var _this = this;
        this.datas = DataManager_1.DataManager.ins.getData(NetName_1.NetName.GET_TEAMINFO).data;
        if (this.datas.validNum) {
            this.frendCountText.text = this.datas.validNum;
        }
        else {
            this.frendCountText.text = "0";
        }
        if (this.datas.extraRate) {
            this.extraRateText.text = this.datas.extraRate.toFixed(3) + "倍";
        }
        else {
            this.extraRateText.text = "0倍";
        }
        var orgX = 41;
        var space = 10;
        if (this.datas.member) {
            this.datas.member.forEach(function (data, i) {
                _this.dItems[i] = new FriendItemComponent_1.FriendItemComponent(data.avatar, data.nickname, _this.secondToDate(data.remainingTime));
                _this.overTimes[i] = data.remainingTime * 1000 + Date.now();
                _this.showListGroup.addChild(_this.dItems[i]);
                _this.dItems[i].y = i * (132 + space);
            });
        }
        this.showList.viewport.scrollV = 0;
        this.setTimes();
        this.Events["setTimes"] = setInterval(function () {
            _this.setTimes();
        }, 1000);
    };
    TeamScene.prototype.setTimes = function () {
        var _this = this;
        if (!this.datas.member) {
            return;
        }
        this.datas.member.forEach(function (data, i) {
            console.log();
            if (_this.overTimes[i] - Date.now() <= 0 && _this.overTimes[i] - Date.now() > -1000) {
                _this.clearList();
                NetManager_1.NetManager.ins.getTeamInfo(function (succuss) {
                    if (!succuss) {
                        return;
                    }
                    _this.resetList();
                }, window["CFG"].activityId);
            }
            else {
                _this.dItems[i].setTime(_this.secondToDate((_this.overTimes[i] - Date.now()) / 1000));
            }
        });
    };
    // 输出03:05:59  时分秒
    TeamScene.prototype.secondToDate = function (result) {
        if (result >= 0) {
            var h = Math.floor(result / 3600) < 10 ? '0' + Math.floor(result / 3600) : Math.floor(result / 3600);
            var m = Math.floor((result / 60 % 60)) < 10 ? '0' + Math.floor((result / 60 % 60)) : Math.floor((result / 60 % 60));
            var s = Math.floor((result % 60)) < 10 ? '0' + Math.floor((result % 60)) : Math.floor((result % 60));
            return result = h + ":" + m + ":" + s;
        }
        else {
            return result = "00:00:00";
        }
    };
    return TeamScene;
}(Scene_1.default));
exports.default = TeamScene;
__reflect(TeamScene.prototype, "\"c:/Users/duiba/Documents/kuwo/egret/src/teamScene/TeamScene\".TeamScene");
//# sourceMappingURL=TeamScene.js.map