"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var DataConversion_1 = require("../mainScene/DataConversion");
var panelCtrl_1 = require("../ctrls/panelCtrl");
var DogShopItemComponent = (function (_super) {
    __extends(DogShopItemComponent, _super);
    /**
     *
     * @param lv 等级
     * @param name 狗名
     * @param iconName 资源名
     * @param callBack
     */
    function DogShopItemComponent(lv, name, iconName, size, dData, callBack) {
        if (callBack === void 0) { callBack = null; }
        var _this = _super.call(this) || this;
        _this.skinName = 'resource/skins/component/DogShopItemComponent.exml';
        _this.clickCallBack = callBack;
        _this.lv = lv;
        _this.size = size;
        _this.dName = name;
        _this.dData = dData;
        _this.iconName = iconName;
        _this.buyBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, _this.onTap_buyBtn, _this);
        _this.addEventListener(egret.Event.COMPLETE, _this.onSkinComplete, _this);
        if (_this.skin) {
            _this.onSkinComplete();
        }
        return _this;
    }
    DogShopItemComponent.prototype.onSkinComplete = function () {
        this.lvLb.text = 'lv.' + this.lv;
        this.dNameLb.text = this.dName;
        this.dogImg.source = this.iconName;
        this.buyBtn.visible = !this.dData.lock;
        this.disGroup.visible = this.dData.lock;
        if (this.dData.lock) {
            this.lockLb.text = 'LV.' + this.dData.unlockLevel + "解锁";
        }
        else {
            var lb = this.buyBtn['labelDisplay'];
            lb.stroke = 3.9;
            lb.strokeColor = 0x6b4838;
            lb.text = DataConversion_1.default.doConversion(this.dData.summonConsume);
        }
        var h = this.size[1];
        var w = this.size[0];
        if (h > 100) {
            w = Math.floor(w / h * 100);
            h = 100;
        }
        this.dogImg.width = w;
        this.dogImg.height = h;
        this.dogImg.anchorOffsetX = w * 0.5;
        this.dogImg.anchorOffsetY = h * 0.5;
        this.dogImg.x = this.dogImgGroup.width * 0.5;
        this.dogImg.y = this.dogImgGroup.height * 0.5;
        this.removeEventListener(egret.Event.COMPLETE, this.onSkinComplete, this);
    };
    DogShopItemComponent.prototype.removeEvent = function () {
        this.buyBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_buyBtn, this);
    };
    DogShopItemComponent.prototype.onTap_buyBtn = function () {
        if (this.clickCallBack) {
            this.clickCallBack(this.lv);
            console.log('购买id', this.lv);
            panelCtrl_1.default.instance.btnDelay(this.buyBtn);
        }
    };
    DogShopItemComponent.prototype.playAct = function (start) {
        if (start === void 0) { start = 0; }
    };
    DogShopItemComponent.prototype.stopAct = function () {
        // this.act.stop();
    };
    return DogShopItemComponent;
}(eui.Component));
exports.DogShopItemComponent = DogShopItemComponent;
__reflect(DogShopItemComponent.prototype, "\"c:/Users/duiba/Documents/kuwo/egret/src/components/DogShopItemComponent\".DogShopItemComponent");
//# sourceMappingURL=DogShopItemComponent.js.map