"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var GFun_1 = require("./GFun");
var GConsole_1 = require("./GConsole");
var GCache = (function () {
    function GCache() {
    }
    /**
     * 初始化
     * @param keys
     */
    GCache.init = function (keys) {
        var i = 0;
        var len = keys.length;
        this.gKey = '';
        for (i; i < len; i++) {
            this.gKey += '_' + keys[i];
        }
    };
    /**
     * 写入缓存
     * @param key
     * @param value
     * @param type type 缓存类型 localStorage永久缓存 sessionStorage浏览器生命周期结束前'
     */
    GCache.writeCache = function (key, value, type) {
        if (type === void 0) { type = 'localStorage'; }
        if (!window[type]) {
            GConsole_1.GConsole.log(GFun_1.GFun.replace('webview不支持{0}', [type]));
            return;
        }
        window[type].setItem(key + this.gKey, value);
    };
    /**
     * 读取缓存
     * @param key
     * @param type type 缓存类型 localStorage永久缓存 sessionStorage浏览器生命周期结束前'
     * @return
     */
    GCache.readCache = function (key, type) {
        if (type === void 0) { type = 'localStorage'; }
        if (!window[type]) {
            GConsole_1.GConsole.log(GFun_1.GFun.replace('webview不支持{0}', [type]));
            return;
        }
        return window[type].getItem(key + this.gKey);
    };
    /**
     * 删除缓存
     * @param key
     * @param type 缓存类型 localStorage永久缓存 sessionStorage浏览器生命周期结束前
     */
    GCache.removeCache = function (key, type) {
        if (type === void 0) { type = 'localStorage'; }
        if (!window[type]) {
            GConsole_1.GConsole.log(GFun_1.GFun.replace('webview不支持{0}', [type]));
            return;
        }
        window[type].removeItem(key + this.gKey);
    };
    return GCache;
}());
exports.GCache = GCache;
__reflect(GCache.prototype, "\"c:/Users/duiba/Documents/kuwo/egret/libs/tc/util/GCache\".GCache");
//# sourceMappingURL=GCache.js.map