import { DataManager } from './../../libs/tw/manager/DataManager';
import { ModuleTypes } from './../types/sceneTypes';

import Scene from "../views/Scene";
import PanelCtrl from "../ctrls/panelCtrl";
import SceneCtrl from '../ctrls/sceneCtrl';
import { NetManager } from '../../libs/tw/manager/NetManager';
import Loading from '../loading/Loading';
import { Buried } from '../../libs/tw/util/Buried';
import { GCache } from '../../libs/tc/util/GCache';
import { FriendItemComponent } from '../components/FriendItemComponent';
import { NetName } from '../../libs/tw/enum/NetName';
import DataConversion from '../mainScene/DataConversion';
export default class TeamScene extends Scene {

    public mainbg:eui.Image;
    public topCention:eui.Group;
    public frendCountText:eui.Label;
    public extraRateText:eui.Label;
    public backBtn:eui.Button;
    public addFrendBtn:eui.Button;
    public showList:eui.Scroller;
    public showListGroup:eui.Group;
    
    
    public get skinKey() { return 'TeamScene' }
    public get groupName() { return 'team_scene' }

    constructor(data?) {
        super(data);//95fcf3
    }

    Events=[]

    initEvents() {
        super.initEvents();
        this.addFrendBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_addFrendBtn, this);
        this.backBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_backBtn, this);
    }

    removeEvents() {
        super.removeEvents();
        this.addFrendBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_addFrendBtn, this);
        this.backBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_backBtn, this);
        
         //删除子项事件
        this.clearList()
    }

    clearList(){
        clearInterval(this.Events["setTimes"])
        this.dItems.forEach((data,i)=>{
            this.showListGroup.removeChild(this.dItems[i])
        })
    }

    onTap_addFrendBtn(){
        PanelCtrl.instance.btnDelay(this.backBtn);
        PanelCtrl.instance.show(ModuleTypes.SHARE2_PANEL)
    }

    onTap_backBtn(){
        PanelCtrl.instance.btnDelay(this.backBtn);
        NetManager.ins.getHome((succuss) => {
			if (!succuss) {
				return;
			}
            SceneCtrl.instance.change(ModuleTypes.MAIN_SCENE);
		}, this.getQueryString("dailyMark"), window["CFG"].activityId)
    }

    getQueryString(name) {
        var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)");
        var r = window.location.search.substr(1).match(reg);
        if (r != null) return unescape(r[2]);
        return null;
    };

    start(data?) {
        super.start(data);
        this.percentHeight = 100;
    }

    private bgtexture: egret.Texture;
    protected async preLoadRes() {
        //加载背景并设置背景图片
        this.bgtexture = await RES.getResAsync('team_bg_jpg');
        return new Promise(function (resolve, reject) {
            resolve();
        });
    }

    protected onSkinComplete(): void {
        super.onSkinComplete();

        this.mainbg.texture = this.bgtexture;
        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    private onLoad(): void {
        this.initUI();
    }

    private datas
    dItems=[]

    private initUI():void{
        this.dItems=[]
        console.log(this.datas)
        this.clearList()
        this.resetList()
    }

    resetList(){
        this.datas = DataManager.ins.getData(NetName.GET_TEAMINFO).data;

        if(this.datas.validNum){
            this.frendCountText.text=this.datas.validNum;
        }else{
            this.frendCountText.text="0";
        }

        if(this.datas.extraRate){
            this.extraRateText.text=this.datas.extraRate.toFixed(3)+"倍";
        }else{
            this.extraRateText.text="0倍";        
        }
       
       
        let orgX = 41;
        let space = 10;
        this.datas.member.forEach((data,i)=>{
            this.dItems[i] = new FriendItemComponent(data.avatar,data.nickName,this.secondToDate(data.remainingTime));
            this.overTimes[i]=data.remainingTime*1000+Date.now();
            this.showListGroup.addChild(this.dItems[i]);
            this.dItems[i].y = i * (132 + space);
        })
        this.showList.viewport.scrollV=0
        this.setTimes()
        this.Events["setTimes"]=setInterval(()=>{
            this.setTimes()
        },1000)
    }

    overTimes=[]

    setTimes(){
        this.datas.member.forEach((data,i)=>{
            if(this.overTimes[i]-Date.now()<=0){
                this.clearList()
                NetManager.ins.getTeamInfo((succuss)=>{
                    if (!succuss) {
                        return;
                    }
                    this.resetList()
                },window["CFG"].activityId)
            }else{
                this.dItems[i].setTime(this.secondToDate((this.overTimes[i]-Date.now())/1000))
            }
        })
    }

    // 输出03:05:59  时分秒
    secondToDate(result) {
        if(result>=0){
            var h = Math.floor(result / 3600) < 10 ? '0'+Math.floor(result / 3600) : Math.floor(result / 3600);
            var m = Math.floor((result / 60 % 60)) < 10 ? '0' + Math.floor((result / 60 % 60)) : Math.floor((result / 60 % 60));
            var s = Math.floor((result % 60)) < 10 ? '0' + Math.floor((result % 60)) : Math.floor((result % 60));
            return result = h + ":" + m + ":" + s;
        }else{
            return result = "00:00:00"
        }
    }

}
