import Panel from "../views/Panel";
import { ThroughSubmitData } from "../../libs/tw/data/custom/throughSubmit/ThroughSubmitData";
import AchievementPicItem from "../item/AchievementPicItem";
import { NetBuried } from "../NetBuried";

export default class UpgradeRewardPanel1 extends Panel {
    public get skinKey() { return "UpgradeRewardPanel1" }

    /**
     * @param data 升级奖励数据{ achievement:number, redPacket:number, ticket:number }
     */
    constructor(data: any) {
        super(data);
    }

    public redPacketNum: eui.Label;
    public picContainer: eui.DataGroup;


    onSkinComplete() {
        super.onSkinComplete();
        this.redPacketNum.text = this.data["redPacket"] + "元现金红包";
        console.log("achievement");
        console.log(this.data["achievement"]);
        this.picContainer.addChild(new AchievementPicItem(this.data["achievement"]));
        NetBuried.ins.showLog(13)
    }

    onTouchTap(){
        super.onTouchTap()
        NetBuried.ins.clickLog(13)
        if(this.data["callback"]){
            this.data["callback"]()
        }
    }
}