import Panel from "../views/Panel";

export default class RewardPanel extends Panel {
    public get skinKey() { return "RewardPanel" }
    public get groupName() { return "reward_panel" }

    public title: eui.Label;
    public rewardNum: eui.Label;
    public btnOk: eui.Button;

    /**
     * @param data { title:string, rewardNum:number }
     */
    constructor(data: object) {
        super(data);
    }

    onTouchTap(){
        super.onTouchTap()
        
    }

    onSkinComplete() {
        super.onSkinComplete();
        this.title.text = this.data["title"];
        this.rewardNum.text = this.data["rewardNum"];
        this.btnOk.addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
            this.hidePanel();
            if(this.data["callback"]){
                this.data["callback"]()
            }
        }, this);
    }
}