import Panel from "../views/Panel";
import ScoreItem from "../item/ScoreItem";
import DefaultCallback from "../Decorator/DefaultCallback";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetName } from "../../libs/tw/enum/NetName";
import { NetPromise } from "../NetPromise";
import PanelCtrl from "../ctrls/panelCtrl";
import Loading from "../loading/Loading";

@DefaultCallback
export default class ScorePanel extends Panel {
    public get skinKey() { return "ScorePanel" }
    public get groupName() { return "score_panel" }

    public bodyScroller:eui.Scroller;
    public list:eui.List;
    public closeBtn:eui.Button;
    
    initEvents(){
        super.initEvents()
        this.bodyScroller.addEventListener(eui.UIEvent.CHANGE, this.moveHandler, this);
		this.bodyScroller.addEventListener(eui.UIEvent.CHANGE_END, this.outHandler, this);
    }

    needUp=false;

    private moveHandler(evt: eui.UIEvent): void {
		//检测是否超过滚动底部
		// console.log(this.moveScroll.viewport.scrollV);
		// console.log(this.moveScroll.viewport.contentHeight - this.moveScroll.viewport.height);
		console.log(this.bodyScroller.viewport.scrollV > this.bodyScroller.viewport.contentHeight - this.bodyScroller.viewport.height);
		if(this.bodyScroller.viewport.scrollV > (this.bodyScroller.viewport.contentHeight - this.bodyScroller.viewport.height)+40){
			this.needUp = true;
		}
    }
	private outHandler(evt:eui.UIEvent):void{
		//停止滚动时判断needUp是否为true
		console.log(this.needUp);
		if(this.needUp){
			this.needUp = false;
            console.log("加载数据")
            this.addList()
		}
    }
    dataList=[]
    pageNow=1
    onSkinComplete() {
        this.needUp=false;
        this.pageNow=1
        super.onSkinComplete();
        let dataA = DataManager.ins.getData(NetName.KUWO_MUSIC_SCORE).data;
        console.log(dataA)
        for (let i = 0; i < dataA.length; i++) {
            let _data= JSON.parse(dataA[i].musicJson)
            this.dataList.push({
                musicName: _data.name,
                singer: _data.artist,
                pic:_data.pic,
                favorite: true
            });
        }
        this.list.dataProvider = new eui.ArrayCollection(this.dataList);
        this.list.itemRenderer = ScoreItem;
    }

    addList(){
        this.pageNow++
        Loading.instace.show()
        NetPromise.ins.getKuwoMusicScoreKuwo(window["eduSignId"],20,this.pageNow).then((succuss)=>{
            Loading.instace.hide()
            let dataA = DataManager.ins.getData(NetName.KUWO_MUSIC_SCORE).data;
            console.log(dataA)
            for (let i = 0; i < dataA.length; i++) {
                let _data= JSON.parse(dataA[i].musicJson)
                this.dataList.push({
                    musicName: _data.name,
                    singer: _data.artist,
                    pic:_data.pic,
                    favorite: true
                });
            }
            this.list.dataProvider = new eui.ArrayCollection(this.dataList);
            this.list.itemRenderer = ScoreItem;
        }).catch(()=>{
            Loading.instace.hide()
        })
    }
}

