import PanelCtrl from "./ctrls/panelCtrl";
import { ModuleTypes } from "./types/sceneTypes";

export namespace MConfigs {
    export let achievement = {
        1: { id: "0", name: "路人甲", },
        2: { id: "1", name: "练习生" },
        3: { id: "1", name: "扛琴小弟" },
        4: { id: "2", name: "乐队主唱" },
        5: { id: "3", name: "酒吧驻唱" },
        6: { id: "4", name: "签约艺人" },
        7: { id: "5", name: "偶像巨星" }
    }

    export let quest = {
        0: {
            id: "0",
            name: "首次到访",
            reward: "零花钱+10金币",
            maxTime: null,
            todo: () => {
                console.log("去完成首次到访");
            }
        },
        1: {
            id: "1",
            name: "个人中心签到",
            reward: "零花钱+10金币",
            maxTime: null,
            todo: () => {
                console.log("去完成个人中心签到");
            },
        },
        2: {
            id: "2",
            name: "每日分享",
            reward: "零花钱+20金币",
            maxTime: null,
            todo: () => {
                console.log("去完成每日分享");
            },
        },
        3: {
            id: "3",
            name: "收藏歌曲",
            reward: "零花钱+20金币",
            maxTime: 3,
            todo: () => {
                PanelCtrl.instance.show(ModuleTypes.FAVORITE_MUSIC_PANEL);
            },
        },
        4: {
            id: "4",
            name: "收听歌曲",
            reward: "零花钱+20金币",
            maxTime: null,
            todo: () => {
                PanelCtrl.instance.show(ModuleTypes.LISTEN_MUSIC_PANEL);
            }
        }
    }
}