/*
 * Tools.ts
 * Created by 还有醋v on 2020/12/23.
 * Copyright © 2020 haiyoucuv. All rights reserved.
 */

import { NetManager } from "../libs/tw/manager/NetManager";
import To = egret.tween.To;
import PanelCtrl from "./ctrls/panelCtrl";
import { ModuleTypes } from "./types/sceneTypes";
import MedalPanel from "./Panels/MedalPanel";
import { wait } from "./comm/GameConst";

export class Tools {

    public static consumerInfo: {
        nickname: string,
        newUser: boolean,
        popup: boolean,
        ifLogin: boolean,
        loginPresent: {
            spFood1RewardNum: number,
            spFood2RewardNum: number,
        },
    };

    public static getConsumerInfo(): Promise<boolean> {
        return new Promise((resolve) => {
            NetManager.ins.getConsumerInfo((success, res) => {
                if (!success) return resolve(false);

                Tools.consumerInfo = res.data;

                resolve(true);
            });
        });
    }


    public static areaPrice: {
        landId: number,
        price: number
    }[] = [];

    public static getAreaPrice(): Promise<boolean> {
        return new Promise((resolve) => {
            NetManager.ins.areaPrice((success, res) => {
                if (!success) return resolve(false);

                const areaPrice: any = JSON.parse(res.data);
                areaPrice.forEach((v) => {
                    Tools.areaPrice[+v.landId] = v;
                });

                resolve(true);
            });
        });
    }


    /**
     * 小e问答
     */
    public static xiaoEQuestion: {
        type: 0 | 1,
        content: string,
        redirect?: string
        answer?: string
    }[] = [];

    public static getQuestionList(): Promise<boolean> {
        return new Promise((resolve) => {
            NetManager.ins.questionList((success, res) => {
                if (!success) return resolve(false);

                Tools.xiaoEQuestion = JSON.parse(res.data);

                resolve(true);
            });
        });
    }

    /**
     * 勋章数据
     */
    public static medalData: {
        [spId: string]: {
            spId: string,
            name: string,
            status: boolean,
            timestamp: number,
            index: number,
        }
    } = {};

    public static getMedalData() {
        return new Promise((resolve) => {
            NetManager.ins.achieves((success, res) => {
                if (!success) {
                    return resolve(false);
                }

                const medals = {
                    'achv_internship_farmer': 0,
                    'achv_advanced_farmer': 1,
                    'achv_well_breeder': 2,
                    'achv_excellent_farmer': 3,
                };

                res.data.forEach((v) => {
                    const spId = v.spId;
                    Tools.medalData[spId] = v;
                    Tools.medalData[spId].index = medals[spId];
                });

                resolve(true);

            });
        });
    }

    /**
     * 判断是否出成就
     */
    public static judgeMedalPanel() {
        return new Promise(async (resolve) => {
            await wait(250);
            NetManager.ins.achieves((success, res) => {
                if (!success) {
                    resolve(false);
                    return;
                }

                const data = res.data;

                for (let i = 0; i < data.length; i++) {
                    const oldData = Tools.medalData[data[i].spId];
                    if (data[i].status == true && (!oldData || oldData.status == false)) {
                        PanelCtrl.instance.show(MedalPanel, data[i]);
                        break;
                    }
                }

                const medals = {
                    'achv_internship_farmer': 0,
                    'achv_advanced_farmer': 1,
                    'achv_well_breeder': 2,
                    'achv_excellent_farmer': 3,
                };

                res.data.forEach((v) => {
                    Tools.medalData[v.spId] = v;
                    Tools.medalData[v.spId].index = medals[v.spId];
                });

                resolve(true);
            });
        });
    }

    public static gameGroupPrize() {
        return new Promise((resolve) => {
            NetManager.ins.gameGroupPrize(() => {
                resolve(true);
            });
        });
    }

    /**
     * 扣积分流程
     * @param toPlaywayId
     * @param toActionId
     * @param desc
     * @param num 数量
     */
    public static creditsCost(toPlaywayId, toActionId, num, desc?) {
        return new Promise((resolve, reject) => {
            NetManager.ins.creditsCost((success, res) => {
                if (!success) {
                    reject();
                    return;
                }
                const ticket = res.data;
                // 轮询扣积分状态
                NetManager.ins.queryStatus((success, res) => {
                    if (!success || res.data != 1) {
                        reject();
                        return;
                    }
                    resolve(ticket);
                }, ticket, (res) => {
                    return res.data == 0;
                });
            }, toPlaywayId, toActionId, num, desc);
        });
    }
    public static frontdata = null;
    public static gameFrontVariable() {
        return new Promise((resolve) => {
            NetManager.ins.frontVariable((success, res) => {
                this.frontdata = res;
                resolve(true);
            }, { keys: 'balloon_url' })
        })
    }

    public static customInfo = null;
    public static gameCustomInfo() {
        return new Promise((resolve) => {
            NetManager.ins.customInfo((success, res) => {
                this.customInfo = res;
                resolve(true);
            })
        })
    }

    public static frontInfo = null;
    public static gameFrontInfo() {
        return new Promise((r) => {
            NetManager.ins.frontInfo((s, res) => {
                this.frontInfo = res;
                r(true)
            })
        })
    }

}