import Panel from "../views/Panel";
import {getSkinPath} from "../utils";
import TopLayerCtrl from "../ctrls/topLayerCtrl";
import {ModuleTypes} from "../types/sceneTypes";
import {NetManager} from "../../libs/tw/manager/NetManager";
import {MainDispatcher, MainIns} from "../Scenes/MainScene/MainScene";
import {getlogItem} from "../comm/getlogItem";
import List = eui.List;
import ItemRenderer = eui.ItemRenderer;
import Image = eui.Image;
import Label = eui.Label;
import Group = eui.Group;
import { Tools } from "../Tools";

export default class TaskPanel extends Panel {
    public list: List;

    private isShow = false;

    public get skinKey() {
        return 'TaskPanel'
    }

    public get groupName() {
        return 'task_panel'
    }

    constructor(data?) {
        super(data);

    }

    onShowAnim() {
        const canvasH = 750 / window.innerWidth * window.innerHeight;
        egret.Tween.get(this).set({y: canvasH}).to({y: canvasH - 1050}, 300, egret.Ease.quadInOut);
    }

    protected start() {
        super.start();

        this.initUI();
    }

    private initUI(): void {
        MainDispatcher.addEvent('getTaskInfo', this.getTaskInfo, this);
        this.getTaskInfo();
    }

    destroy() {
        MainDispatcher.removeEvent('getTaskInfo', this.getTaskInfo, this);
        super.destroy();
    }

    private getTaskInfo() {
        NetManager.ins.getTaskInfo((success, res) => {
            if (!success) {
                return;
            }
            let data = res.data;
            if (!this.isShow) {
                this.isShow = true;
                data.forEach((v) => {
                    (v.status == 0) ? NetManager.ins.showLog(getlogItem(window['taskUi'][v.id].bid)) : 0;   // 12, 13, 14, 15, 30, 31
                });
            }
            this.list.useVirtualLayout = false;
            this.list.itemRenderer = TaskItem;
            this.list.dataProvider = new eui.ArrayCollection(data);
        });
    }
}

////////////////////////////////////////////////////////////////////////////////////////////////
/**
 * 任务中心列表
 */
class TaskItem extends ItemRenderer {
    public icon: Image;
    public title: Label;
    public textKHD: Label;
    public prizeGroup: Group;
    public foodGroup: Group;
    public textFood: Label;
    public waterGroup: Group;
    public textWater: Label;
    public btn: Group;
    public btn_bg: Image;
    public btn_bg_dis:Image;
    public btn_label: Label;

    constructor() {
        super();
        this.skinName = getSkinPath('TaskItem');
    }

    dataChanged() {

        if (this.data.id == 1) this.data.status = 1;    // TODO 2020.12.24 改成登陆奖励，直接写死已领取

        this.icon.source = window['taskUi'][this.data.id].icon;
        this.title.text = window['taskUi'][this.data.id].label;

        this.textFood.text = '×' + this.data.spFood1RewardNum;
        this.textWater.text = '×' + this.data.spFood2RewardNum;

        /// TODO 0奖励隐藏的临时低效方案，待优化
        if (this.data.spFood1RewardNum <= 0) {
            this.foodGroup.visible = false;
            this.waterGroup.x = this.foodGroup.x;
        }
        if (this.data.spFood2RewardNum <= 0) {
            this.waterGroup.visible = false;
        }
        this.setBtn();
    }

    private setBtn() {
        this.btn_label.text = (this.data.status == 0) ? window['taskUi'][this.data.id].btnLabel : '已领取';
        this.btn_label.textColor = (this.data.status == 0) ? 0xffffff : 0xffffff;
        this.btn_bg.visible = (this.data.status == 0);
        this.btn_bg_dis.visible = (this.data.status != 0);

        let _f = () => {
            if(this.data.spFood1RewardNum||this.data.spFood2RewardNum){
                TopLayerCtrl.instance.show(ModuleTypes.TASK_TOAST, {
                    title: (this.data.id == 1) ? '签到成功' : '分享成功',
                    food: this.data.spFood1RewardNum,
                    water: this.data.spFood2RewardNum,
                });
            }
            MainDispatcher.dispatchEvent('getTaskInfo');
            MainIns().mainUI.getPropInfo();
        };

        if (this.data.status == 0) {
            this.btn.addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
                this.btn.touchEnabled = false;
                NetManager.ins.clickLog(getlogItem(window['taskUi'][this.data.id].bid));   // 12, 13, 14, 15
                NetManager.ins.doTask((success, res) => {
                    this.touchEnabled = true;
                    if (!success) {
                        return;
                    }

                    if (this.data.id == 1 || this.data.id == 2) {
                        (this.data.id == 2) ? (
                            window['share'](),
                                setTimeout(_f, 3000)) : _f();
                    } else {
                        MainDispatcher.dispatchEvent('getTaskInfo');
                        MainIns().mainUI.getPropInfo();
                        if (window['taskUi'][this.data.id].linkId) {
                            console.error("任务点击1===》",window['taskUi'][this.data.id].linkId);
                            window['getActivityInfo'](window['taskUi'][this.data.id].linkId);
                        } else {
                            console.error("任务点击2===》",this.data.url || window['taskUi'][this.data.id].link,Tools.customInfo.data);
                            let signstr = Tools.customInfo.data.custid+""+15+""+this.data.id+""+Tools.customInfo.data.cisno;
                            let sign = window['duiba_md5'](signstr);

                            let jumplink = (this.data.url || window['taskUi'][this.data.id].link)+"&custid="+Tools.customInfo.data.custid+"&taskid="+this.data.id+"&durtime="+15+"&sign="+sign;
                            console.error("跳转检查===》",jumplink);
                            window.location.href = this.data.url || window['taskUi'][this.data.id].link;
                        }
                    }
                }, this.data.id);
            }, this);
        }
    }
}
