//  import { NetManager } from "../../manager/NetManager"; import { DataManager } from "../../manager/DataManager";
import { PetIndexData } from "../../data/pet/PetIndexData";
import { PetHomeInfoData } from './../../data/pet/PetHomeInfoData';
import { SignInfoData } from './../../data/pet/SignInfoData';
import { ActivityModel } from "./ActivityModel";
import { NetManager } from "../../manager/NetManager";
import { DataManager } from "../../manager/DataManager";

export class SignModel extends ActivityModel {
    /**
     * 签到接口
     * @param {Function} callback
     * @param {number} signActivityId 签到插件ID
     */
    public doSign(callback: Function, signActivityId: number): void {
        NetManager.ins.doSign(callback, signActivityId, DataManager.ins.petIndexData.activityId);
    }

    
    /**
     * 用户基础数据
     */
    public get petIndexData():PetIndexData
    {
        return DataManager.ins.petIndexData;
    }

    /**
     * 宠物基础数据
     */
    public get petHomeInfoData():PetHomeInfoData
    {
        return DataManager.ins.petHomeInfoData;
    }

    /**
     * 签到详情数据
     */
    public get signInfoData():SignInfoData
    {
        return DataManager.ins.signInfoData;
    }
}