import { Data } from "../Data";

/**
 * 宠物领养
 */
export class PetAdopteData extends Data {
    /**
     * 宠物id
     */
    public petId: number;

    /**
     * 宠物领养
     */
    public type: number;

    /**
     * 活动id
     */
    public activityId: string;

    /**
     * 宠物名称
     */
    public petName: string;

    /**
     * 宠物等级
     */
    public petLevel: number;

    /**
     * 累计收到食物
     */
    public totalReceivedNum: number;

    /**
     * 累计消耗食物
     */
    public totalEatNum: number;

    /**
     * 当前状态（1:正常 2:外出 3:吃饭 4:学习 5:喝水 6:睡觉）
     */
    public status: number;

    /**
     * 拥有萝卜数量
     */
    public foodNum: number;

    /**
     * 状态剩余时间
     */
    public leftMinutes: number;

    public update(result: any): void {
        if (!result) {
            return;
        }
        super.update(result);
        if(!result.data) {
            return;
        }
        result = result.data;
        this.petId = result.petId;
        this.type = result.type;
        this.activityId = result.activityId;
        this.petName = result.petName;
        this.petLevel = result.petLevel;
        this.totalReceivedNum = result.totalReceivedNum;
        this.totalEatNum = result.totalEatNum;
        this.status = result.status;
        this.foodNum = result.foodNum;
        this.leftMinutes = result.leftMinutes;
    }
}