"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = require("../views/Panel");
var utils_1 = require("../utils");
var topLayerCtrl_1 = require("../ctrls/topLayerCtrl");
var sceneTypes_1 = require("../types/sceneTypes");
var NetManager_1 = require("../../libs/tw/manager/NetManager");
var MainScene_1 = require("../Scenes/MainScene/MainScene");
var getlogItem_1 = require("../comm/getlogItem");
var taskUi = {
    1: {
        icon: '签到 icon_png',
        btnLabel: '去签到',
        label: '每日签到'
    },
    2: {
        icon: '分享 icon_png',
        btnLabel: '去分享',
        label: '分享给好友'
    },
    3: {
        icon: '消费 icon_png',
        btnLabel: '去完成',
        label: '访问欢趣派对',
        link: 'https://gonghang.activity-1.m.duiba.com.cn/projectx/p0f8b79c7/index.html'
    },
    4: {
        icon: '生活日 icon_png',
        btnLabel: '去完成',
        label: '访问欢趣市集',
        link: 'https://gonghang.activity-1.m.duiba.com.cn/hdtool/index?id=3737984&dbnewopen'
    },
};
var TaskPanel = (function (_super) {
    __extends(TaskPanel, _super);
    function TaskPanel(data) {
        var _this = _super.call(this, data) || this;
        _this.isShow = false;
        return _this;
    }
    Object.defineProperty(TaskPanel.prototype, "skinKey", {
        get: function () {
            return 'TaskPanel';
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(TaskPanel.prototype, "groupName", {
        get: function () {
            return 'task_panel';
        },
        enumerable: true,
        configurable: true
    });
    TaskPanel.prototype.onShowAnim = function () {
        var canvasH = 750 / window.innerWidth * window.innerHeight;
        egret.Tween.get(this).set({ y: canvasH }).to({ y: canvasH - 1010 }, 300, egret.Ease.quadInOut);
    };
    TaskPanel.prototype.start = function () {
        _super.prototype.start.call(this);
        this.initUI();
    };
    TaskPanel.prototype.initUI = function () {
        MainScene_1.MainDispatcher.addEvent('getTaskInfo', this.getTaskInfo, this);
        this.getTaskInfo();
    };
    TaskPanel.prototype.destroy = function () {
        MainScene_1.MainDispatcher.removeEvent('getTaskInfo', this.getTaskInfo, this);
        _super.prototype.destroy.call(this);
    };
    TaskPanel.prototype.getTaskInfo = function () {
        var _this = this;
        NetManager_1.NetManager.ins.getTaskInfo(function (success, res) {
            if (!success) {
                return;
            }
            var data = res.data;
            if (!_this.isShow) {
                _this.isShow = true;
                data.forEach(function (v) {
                    (v.status == 0) ? NetManager_1.NetManager.ins.showLog(getlogItem_1.getlogItem(v.id + 11)) : 0; // 12, 13, 14, 15
                });
            }
            _this.list.useVirtualLayout = false;
            _this.list.itemRenderer = TaskItem;
            _this.list.dataProvider = new eui.ArrayCollection(data);
        });
    };
    return TaskPanel;
}(Panel_1.default));
exports.default = TaskPanel;
__reflect(TaskPanel.prototype, "\"/Users/haiyoucuv/Documents/Web/\u5DE5\u884C\u5361\u4E2D\u5FC3--\u6B22\u8DA3\u5E84\u56ED\u6D3B\u52A8/JoyousManor/egret/src/Panels/TaskPanel\".TaskPanel");
////////////////////////////////////////////////////////////////////////////////////////////////
/**
 * 任务中心列表
 */
var TaskItem = (function (_super) {
    __extends(TaskItem, _super);
    function TaskItem() {
        var _this = _super.call(this) || this;
        _this.skinName = utils_1.getSkinPath('TaskItem');
        return _this;
    }
    TaskItem.prototype.dataChanged = function () {
        this.icon.source = taskUi[this.data.id].icon;
        this.title.text = taskUi[this.data.id].label;
        this.textFood.text = '×' + this.data.spFood1RewardNum;
        this.textWater.text = '×' + this.data.spFood2RewardNum;
        /// TODO 0奖励隐藏的临时低效方案，待优化
        if (this.data.spFood1RewardNum <= 0) {
            this.foodGroup.visible = false;
            this.waterGroup.x = this.foodGroup.x;
        }
        if (this.data.spFood2RewardNum <= 0) {
            this.waterGroup.visible = false;
        }
        this.setBtn();
    };
    TaskItem.prototype.setBtn = function () {
        var _this = this;
        this.btn_label.text = (this.data.status == 0) ? taskUi[this.data.id].btnLabel : '已领取';
        this.btn_label.textColor = (this.data.status == 0) ? 0xffffff : 0x9a9a9a;
        this.btn_bg.visible = (this.data.status == 0);
        var _f = function () {
            topLayerCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.TASK_TOAST, {
                title: (_this.data.id == 1) ? '签到成功' : '分享成功',
                food: _this.data.spFood1RewardNum,
                water: _this.data.spFood2RewardNum,
            });
            MainScene_1.MainDispatcher.dispatchEvent('getTaskInfo');
            MainScene_1.MainIns().mainUI.getPropInfo();
        };
        if (this.data.status == 0) {
            this.btn.addEventListener(egret.TouchEvent.TOUCH_TAP, function () {
                _this.btn.touchEnabled = false;
                NetManager_1.NetManager.ins.clickLog(getlogItem_1.getlogItem(_this.data.id + 11)); // 12, 13, 14, 15
                NetManager_1.NetManager.ins.doTask(function (success, res) {
                    _this.touchEnabled = true;
                    if (!success) {
                        return;
                    }
                    if (_this.data.id == 1 || _this.data.id == 2) {
                        (_this.data.id == 2) ? (window['share'](),
                            setTimeout(_f, 3000)) : _f();
                    }
                    else {
                        MainScene_1.MainDispatcher.dispatchEvent('getTaskInfo');
                        MainScene_1.MainIns().mainUI.getPropInfo();
                        window.location.href = taskUi[_this.data.id].link;
                    }
                }, _this.data.id);
            }, this);
        }
    };
    return TaskItem;
}(eui.ItemRenderer));
__reflect(TaskItem.prototype, "TaskItem");
//# sourceMappingURL=TaskPanel.js.map