import Panel from "../../views/Panel";

export default class ToastPanel extends Panel {
    public msgLb: eui.Label;
    public bgRect: eui.Rect;

    private mdata: any;

    public get skinKey() {
        return 'ToastPanel'
    }

    constructor(data) {
        super(data);
        this.mdata = data;
    }

    onShowAnim() {

    }

    onSkinComplete() {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if(this.stage) {
            this.onLoad();
        }
    }

    initEvents() {
        super.initEvents();
    }

    removeEvents() {
        super.removeEvents();
    }

    private onLoad(): void {
        if(this.mdata) {
            this.msgLb.text = this.mdata.msg;
        }

        const canvasW = 750 / window.innerWidth * window.innerWidth;
        const canvasH = 750 / window.innerWidth * window.innerHeight;
        this.anchorOffsetX = this.width / 2;
        this.anchorOffsetY = this.height / 2;
        this.x = canvasW / 2;
        this.y = canvasH / 2;
        egret.Tween.removeTweens(this);
        egret.Tween.get(this)
            .set({scaleX: 0, scaleY: 0})
            .to({scaleX: 1, scaleY: 1}, 230, egret.Ease.backOut)
            .wait(800)
            .to({alpha: 0}, 400, egret.Ease.quadInOut)
            .call(this.onTouchClose.bind(this));
    }
}