"use strict";
// // 用法示例:
// // 创建一个形状
// function getShape(x, y, w, h) {
//     let newShape = new egret.Shape();
//     newShape.graphics.beginFill(0x000000);
//     newShape.graphics.drawRect(x, y, w, h);  // 要镂空的大小和位置
//     newShape.graphics.endFill();
//     return newShape;
// }
//
// let shape = getShape(100, 100, 100, 100);
// let rMask = new ReverseMask(shape);   // 创建一个ReverseMask
// this.addChild(rMask);    // 加入场景
//
// // 使用缓动改变镂空位置
// // 使用缓动改变 hole 的位置或透明度，需要监听onChange设置为render函数
// egret.Tween.get(rMask.hole, {onChange: rMask.render}).to({x: 500, y: 500, alpha: 0.7}, 1000).call(() => {
//     egret.Tween.get(rMask.hole, {onChange: rMask.render}).to({x: 200, y: 800, alpha: 1}, 1000).call(() => {
//         rMask.setMask({x: 100, y: 100, w: 800, h: 800});    // 直接对mask进行重设
//
//         let shape2 = getShape(300, 300, 150, 150);
//         rMask.hole = shape2;    // 直接对hole赋值进行重设
//     });
// })
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * 简单的反向遮罩
 */
var ReverseMask = (function (_super) {
    __extends(ReverseMask, _super);
    function ReverseMask(hole, rect) {
        var _this = _super.call(this) || this;
        _this.canvasW = 750 / window.innerWidth * window.innerWidth;
        _this.canvasH = 750 / window.innerWidth * window.innerHeight;
        _this.__mask = new egret.Shape(); // 外面的遮罩
        ///////////////////// Public Method /////////////////////
        _this.render = function () {
            var renderTex = new egret.RenderTexture();
            renderTex.drawToTexture(_this._shape);
            _this['__shape'] = new egret.Bitmap(renderTex);
            _this.mask = _this['__shape'];
            !_this['__shape'].parent && _this.addChild(_this['__shape']);
        };
        _this._hole = hole;
        _this._rect = rect || { x: 0, y: 0, w: _this.canvasW, h: _this.canvasH };
        _this.setMask(rect);
        return _this;
    }
    Object.defineProperty(ReverseMask.prototype, "hole", {
        get: function () {
            return this._hole;
        },
        set: function (hole) {
            this._hole = hole;
            this.setShape(this._rect);
        },
        enumerable: true,
        configurable: true
    });
    ReverseMask.prototype.setMask = function (rect) {
        this.__mask.graphics.clear();
        this.__mask.graphics.beginFill(0x000000, 0.65);
        if (rect) {
            this.__mask.graphics.drawRect(rect.x, rect.y, rect.w, rect.h);
        }
        else {
            this.__mask.graphics.drawRect(0, 0, this.canvasW, this.canvasH);
        }
        this.__mask.graphics.endFill();
        this.addChild(this.__mask);
        this.setShape(rect);
    };
    ///////////////////// Private Method /////////////////////
    ReverseMask.prototype.setShape = function (rect) {
        this._shape = new egret.Sprite();
        this._shape.graphics.beginFill(0xffffff);
        if (rect) {
            this._shape.graphics.drawRect(rect.x, rect.y, rect.w, rect.h);
        }
        else {
            this._shape.graphics.drawRect(0, 0, this.canvasW, this.canvasH);
        }
        this._shape.graphics.endFill();
        this._hole.blendMode = egret.BlendMode.ERASE;
        this._shape.addChild(this._hole);
        this.render();
    };
    return ReverseMask;
}(eui.Component));
exports.default = ReverseMask;
__reflect(ReverseMask.prototype, "\"/Users/haiyoucuv/Documents/Web/\u5DE5\u884C\u5361\u4E2D\u5FC3--\u6B22\u8DA3\u5E84\u56ED\u6D3B\u52A8/JoyousManor/egret/src/comm/ReverseMask\".ReverseMask");
//# sourceMappingURL=ReverseMask.js.map