import { IModuleData } from './../interface/IModuleData';

/**
 * 模块管理器
 */
export abstract class ABModuleManager {
    /**
     * 初始化
     * @param {ModuleData} modules
     */
    public abstract init(modules: IModuleData[]): void

    /**
     * 按模块名获取模块数据
     * @param {string} moduleName 模块名
     * @returns {ModuleData}
     */
    public abstract getModule(moduleName: string): IModuleData

    /**
     * 打开一个模块
     * @param {string} moduleName 模块名
     * @param args 携带参数
     */
    public abstract openModule(moduleName: string, ...args): void

    /**
     * 访问模块内的公用方法
     * @param {string} moduleName 模块名
     * @param {string} funcName 方法名
     */
    public abstract callModuleFunc(moduleName: string, funcName: string, ...args): void
}