let inquirer = require('inquirer');
const spawn = require('cross-spawn');
const questions = require('./question');
let moment = require('moment');
const today = moment().format('YYYYMMDD');

inquirer.prompt(questions).then(answers => {
  let cmdType = answers.commandType || '';
  let skinName = answers.skinName || '';
  let branchName = answers.branchName || '';
  let cmd = '';

  switch (cmdType) {
    case 'create':
      cmd = `npm run copy ${skinName}`;
      break;
    case 'create_react':
      cmd = `npm run copy ${skinName} custom-react`;
      break;
    case 'prettier':
      cmd = 'npm run lint';
      break;
    case 'develop':
      cmd = `npm run dev ${skinName}`;
      break;
    case 'build_test':
      cmd = `npm run build ${skinName}`;
      break;
    case 'build_prod':
      cmd = `npm run build ${skinName} prod`;
      break;
    case 'backup':
      cmd = `npm run backup`;
      break;
    case 'create_branch':
      cmd = `git checkout -b feature/${today}-${branchName}`;
      break;
    default:
      break;
  }

  if (cmd) {
    cmd = cmd.split(' ');
    let _cmd = cmd[0];
    let _args = cmd.slice(1);

    var ls = spawn(_cmd, _args);

    ls.stdout.on('data', data => {
      console.log(`${data}`);
    });

    ls.stderr.on('data', data => {
      console.log(`stderr: ${data}`);
    });

    ls.on('close', code => {
      // console.log(`子进程退出码：${code}`);
    });
  }
});
