export abstract class ABVideoManager {
    /**
     * 创建视频
     * @param {string} name 名字
     * @param {string} src 视频链接
     * @param {number} width 视频宽，默认可以不填
     * @param {number} height 视频高，默认可以不填
     */
    public abstract createVideo(name: string, src: string, width?: number, height?: number): void

    /**
     * 获取当前最新的一个video对象
     * @returns {any}
     */
    public abstract getVideo(name: string): any

    /**
     * 开始播放媒体
     * @method play
     * @param {number} start 开始点 默认为0
     * @param {number} loop 循环次数 默认为1
     */
    public abstract play(start?: number, loop?: number): void

    /**
     * 暂停播放,或者恢复播放
     * @method pause
     * @param isPause  默认为true;是否要暂停，如果要暂停，则暂停；否则则播放
     */
    public abstract pause(isPause?: boolean): void

    /**
     * 停止播放
     */
    public abstract stop(): void
}