import Body from "./playScene/physics/Body";
import { sqrt3 } from "./playScene/physics/Const";
export default class Effect {
    NUMS_MAX = 11;
    _parent: egret.DisplayObjectContainer;
    constructor(block: Body, parent: egret.DisplayObjectContainer) {
        const resName = block.view['bg']['__resName__']
        for (let i = 0; i < this.NUMS_MAX; i++) {
            const data = this.createItem(resName);
            parent.addChild(data.shape);
            data.shape.x = block.x;
            data.shape.y = block.y;
            egret.Tween.get(data.shape).to({ x: data.targetX + block.x, y: block.y + data.targetY, scaleY: 0, scaleX: 0 }, 360).call(() => {
                data.shape.parent && data.shape.parent.removeChild(data.shape);
            });
        }
    }

    createItem(resName: string) {
        const moveDisMax = 100;
        const squareSize = 100;
        const shape = new egret.Shape();
        const shapeType = this.getShapeType(resName);
        if (shapeType == 'circle') {
            shape.graphics.beginFill(this.getShapeColor(resName));
            shape.graphics.drawCircle(0, 0, squareSize / 2);
            shape.graphics.endFill();
        } else if (shapeType == 'tri') {
            shape.graphics.beginFill(this.getShapeColor(resName));
            shape.graphics.moveTo(0, -squareSize * sqrt3 / 3);
            shape.graphics.lineTo(squareSize / 2, squareSize * sqrt3 / 6);
            shape.graphics.lineTo(-squareSize / 2, squareSize * sqrt3 / 6);
            shape.graphics.endFill();
        } else if (shapeType == 'sq') {
            shape.graphics.beginFill(this.getShapeColor(resName));
            shape.graphics.drawRect(-squareSize / 2, -squareSize / 2, squareSize, squareSize);
            shape.graphics.endFill();
        }

        const scale = Math.random() * 0.7 + 0.3;
        const rotation = Math.random() * 360;
        const angle = Math.random() * Math.PI * 2;
        const dis = moveDisMax / 2 + moveDisMax / 2 * Math.random();
        const targetX = Math.sin(angle) * dis;
        const targetY = Math.cos(angle) * dis;
        shape.scaleX = shape.scaleY = scale;
        shape.rotation = rotation;
        return { shape: shape, targetX: targetX, targetY: targetY };
    }

    getShapeType(resName: string) {
        if (resName == 'circle1_png')
            return 'circle';
        if (resName.indexOf('tri') > -1)
            return 'tri';
        if (resName.indexOf('sq') > -1)
            return 'sq';
        return 'circle'
    }

    getShapeColor(resName: string) {
        if (resName == 'circle1_png')
            return 0xffca55;
        if (resName == 'sq1_png')
            return 0xfa7782;
        if (resName == 'sq2_png')
            return 0xf677ce;
        if (resName == 'sq3_png')
            return 0xffac84;
        if (resName == 'sq4_png')
            return 0xffca55;
        if (resName == 'tri1_png')
            return 0x2db0ee;
        if (resName == 'tri2_png')
            return 0x86e45f;
        return 0xffca55

    }
}