import ComponentBase from "./ComponentBase";

export default class Panel extends ComponentBase {
    constructor() {
        super();
    }

    initEvents() {
        this.closeBtns.forEach(
            btn => { if (btn) btn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap_closeBtn, this) }
        )
    }
    removeEvents() {
        this.closeBtns.forEach(
            btn => { if (btn) btn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap_closeBtn, this) }
        )
    }

    protected get closeBtns(): eui.Button[] { return [this['closeBtn']] }

    onTouchTap_closeBtn() {
        this.hidePanel();
    }

    hidePanel() {
        this.destroy();
        this.dispatchEvent(new egret.Event('onDestroy'));
    }

}