let soundOn = true;
let bgChannel: egret.SoundChannel;
let loading = false;
export const getSoundOn = () => {
    return soundOn
}

export const toggleSound = () => {
    soundOn = !soundOn;
    if (bgChannel) {
        if (!soundOn) {
            bgChannel.stop();
            bgChannel = null;
        }
    } else {
        if (soundOn) {
            playBg();
        }
    }
}

export const playBg = async () => {
    if (bgChannel) return;
    if (loading) return;
    loading = true;
    const bg = await RES.getResAsync('bg_mp3');
    bgChannel = bg.play();
    loading = false;
}

export enum SoundType {
    click = 'click',
    bounce = 'bounce',
    good = 'good',
    recover = 'recover',
    shoot = 'shoot',
}

export const playSound = (type: SoundType) => {
    if (!soundOn) return;
    const sound: egret.Sound = RES.getRes(type + "_mp3");
    if (sound)
        sound.play(0, 1);
    else
        RES.getResAsync(type + "_mp3")
}