/**
 *Created by cuiliqiang on 2018/3/1
 * 奖品信息
 */
import { LotteryType } from "../../../enum/LotteryType";
// import { IData } from "../../../../tc/interface/IData";
import { IExposureData } from "../IExposureData";
import { IData } from "../../../../tc/interface/IData";

export class LotteryData implements IData {
    /**
     * 广告ID
     */
    public id: number;

    /**
     * 安卓下载链接
     */
    public androidDownloadUrl: string;

    /**
     * 图片链接
     */
    public img: string;

    /**
     * IOS下载链接
     */
    public iosDownloadUrl: string;

    /**
     * 跳转地址
     */
    public link: string;

    /**
     * 奖品名字
     */
    public name: string;

    /**
     * 
     */
    public openUrl: string;

    /**
     * 是否展示立即使用按钮
     */
    public showUse: boolean;

    /**
     * 
     */
    public tip: string;
    
    /**
     * 标题
     */
    public title: string;

    /**
     * 立即使用按钮文案
     */
    public useBtnText: string;

    /**
     * 有效日期
     */
    public validate: string;

    /**
     * 奖品类型
     */
    public type: LotteryType;

    /**
     * 关闭按钮埋点
     */
    public closeExposure: IExposureData;

    /**
     * 立即使用按钮埋点
     */
    public useExposure: IExposureData;

    /**
     * 奖品图片埋点
     */
    public imgExposure: IExposureData;

    /**
     * 是否弹出下载提示框
     */
    public confirm: string;

    /**
     * 集卡id
     */
    public itemId: number;

    public update(data: any): void {
        if (!data) {
            return;
        }
        this.androidDownloadUrl = data.androidDownloadUrl;
        this.iosDownloadUrl = data.iosDownloadUrl;
        this.img = data.imgUrl;
        this.link = data.link;
        this.name = data.name ? data.name : data.title;
        this.openUrl = data.openUrl;
        this.showUse = data.showUse;
        this.tip = data.tip;
        this.title = data.title;
        this.useBtnText = data.useBtnText;
        this.validate = data.validate;
        this.type = data.type;
        this.confirm = data.confirm;
        this.id = data.id;

        if (data.stinfodpmclose) {
            this.closeExposure = JSON.parse(data.stinfodpmclose);
        } else {
            this.closeExposure = null;
        }

        if (data.stinfodpmgouse) {
            this.useExposure = JSON.parse(data.stinfodpmgouse);
        } else {
            this.useExposure = null;
        }

        if (data.stInfoDpmImg) {
            this.imgExposure = JSON.parse(data.stInfoDpmImg);
        } else {
            this.imgExposure = null;
        }
        if(data.itemId){
            this.itemId = data.itemId;
        }
    }
}