import showCustomLog from "../../new_tw/ctrls/showCustomLog";
import { LotteryType } from "../../tw/enum/LotteryType";
import { DataManager } from "../../tw/manager/DataManager";
import { NetManager } from "../../tw/manager/NetManager";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import Panel from "./Panel";
export default class PrizePanel extends Panel {
    start(data) {
        super.start();

        const lottery = DataManager.ins.getCustomOrderStatusData.lottery;
        this.data = lottery;
        this.data.score = `本局分数 ${DataManager.ins.getData('ngameSubmit').data.score}`;


        var imgLoader: egret.ImageLoader = new egret.ImageLoader();
        egret.ImageLoader.crossOrigin = "anonymous";
        imgLoader.load(this.data.img);
        imgLoader.once(egret.Event.COMPLETE, (evt: egret.Event) => {
            if (evt.currentTarget.data) {
                let texture = new egret.Texture();
                texture.bitmapData = evt.currentTarget.data;

                let maxheight = 220;
                let imgwid = texture.textureWidth;
                let imghei = texture.textureHeight;
                if (imghei > maxheight) {
                    imgwid *= 220 / imghei;
                    imghei = maxheight;

                }
                this.img.width = imgwid;
                this.img.height = imghei;
            }
        }, this);


        // this.img.width = this.picBigWidth;
        // this.img.height = this.picBigWidth / this.bigPicRatio;

        showCustomLog(lottery);
    }

    onTouchTap_closeBtn(): any {
        super.onTouchTap_closeBtn();
        SceneCtrl.instance.change(ModuleTypes.START_SCENE);
    }

    get picBigWidth() { return 510 };
    get bigPicRatio() { return 640 / 300 }

    initEvents() {
        super.initEvents();
        this.useBtn.once(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
        this.img.once(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
    }
    onUse() {
        const lottery = DataManager.ins.getCustomOrderStatusData.lottery;
        if (lottery.type == LotteryType.COUPON || lottery.type == LotteryType.LUCKY) {
            window["downloadAppConfig"] =
            {
                openUrl: lottery.openUrl,
                iosDownloadUrl: lottery.iosDownloadUrl,
                androidDownloadUrl: lottery.androidDownloadUrl,
                confirm: lottery.confirm ? lottery.confirm : false
            };
            window["downloadApp"]();
            if (lottery.type == "lucky") {
                NetManager.ins.spmclick(DataManager.ins.getCustomOrderStatusData.exposure);
            }
        }
        else {
            window.location.href = lottery.link;
        }
    }

    img: eui.Image;
    useBtn: eui.Button;
    get skinKey() { return 'Prize' }

    protected get closeBtns(): eui.Button[] {
        return [this['closeBtn']]
    }
}