import { Data } from "../tw/data/Data";
import { NetName } from "../tw/enum/NetName";
import showAlertPanel from "./ctrls/showAlertPanel";

export default (data?: Data, netname?: NetName) => {
    if (!data) {
        return showAlertPanel('网络异常\n请隔一段时间再尝试');
    }
    if (data.code == 'E999999999')//系统级别错误  系统异常，\n请刷新后重试。
        showAlertPanel('网络异常\n请隔一段时间再尝试');
    else if (data.code == 'E100201001')
        showAlertPanel('请登录后重试。')
    else if (data.code == 'E100201007') {
        showAlertPanel(`对不起\n您的${CFG.unitName}不足`);
    }
    else if (data.code == 'E100202007' || data.code == 'E100202008' || data.code == 'E100202009' || data.code == 'E100202010')
        showAlertPanel('对不起\n您的次数不足。')
    else//其他异常
        showAlertPanel('网络异常\n请隔一段时间再尝试')
}
// export default (data: Data) => {
//     if (data.code == 'E999999999')
//         showAlertPanel(AlertType.NO_TYPE);
//     else if (data.code == 'E100201001')
//         showAlertPanel(AlertType.NOT_LOGIN);
//     else if (data.code == 'E100202007' || data.code == 'E100202008' || data.code == 'E100202009' || data.code == 'E100202010')
//         showAlertPanel(AlertType.NO_TIMES);
//     else
//         showAlertPanel(AlertType.NO_TYPE)
// }