import { DataManager } from './../../libs/tw/manager/DataManager';
import { NetManager } from './../../libs/tw/manager/NetManager';
import NoPrizePanel from "../../libs/new_wx/components/NoPrizePanel";
import SceneCtrl from "../../libs/new_wx/ctrls/sceneCtrl";
import PanelCtrl from '../../libs/new_wx/ctrls/panelCtrl';
import { ModuleTypes } from "../../libs/new_wx/types/sceneTypes";
export default class ExNoPrziePanel extends NoPrizePanel {
    
    onTap_againBtn(){
        this.againBtn.touchEnabled = false;
        if(DataManager.ins.getInfoData.status.code == 3){
            // 参与次数已用完
            let data = {msg:`今日次数已用完\n明日再来吧~`, type:'err'}
            PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, data)
            return;
        }else if(DataManager.ins.getInfoData.status.code == 2){
            // 积分不足
            let data = {msg:`积分不足\n去赚积分吧`, type:'creditsOut'}
            PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, data)
            return;
        }else if(DataManager.ins.getInfoData.status.code == 1){
            // 未登录
            let data = {msg:`未登录账号\n请先登录`, type:'requirelogin'}
            PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, data)
            return;
        }else{
            this.doStart(this.doStartResult.bind(this),false)
        }
        
    }

    public doStart(callback: Function, isAgain = false, credits?: number, customizedType?: number): void {
        if(window['requirelogin']) {
            window['requirelogin']();
            return;
        }
        NetManager.ins.doStart((success: boolean) => {
            if(success) {
                this.getStartOrderStatus(callback, customizedType);
            } else {
                callback(success);
            }
        },
        isAgain,
        credits,
        customizedType);
    }

    private getStartOrderStatus(callback: Function, customizedType?: number): void {
        NetManager.ins.getStartStatus(
            callback,
            DataManager.ins.doStartData.ticketId,
            () => { return DataManager.ins.getStartStatusData.code == 0; },
            5,
            customizedType);
    }

    // 开始的回调
    private doStartResult(success:boolean){
        
        if(!success) {
            return;
        }
        PanelCtrl.instance.closeCurrent();
        setTimeout(() => {
            SceneCtrl.instance.change(ModuleTypes.PLAY_SCENE);    
            this.againBtn.touchEnabled = true;
        }, 1000);
        
    }
}