import Scene from "../MViews/MScene";
import MButton from "../MUI/MButton";
import SceneCtrl from "../MCtrls/MSceneCtrl";
import MainScene from "./MainScene";
import PanelCtrl from "../MCtrls/MPanelCtrl";
import Net from "../Global/Net";
import { Decorator } from "../Decorator/Decorator";
import SoundMgr from "../Mgr/SoundMgr";
import GameMgr from "../Mgr/GameMgr";
import RankListPanel from "../Panel/RankListPanel";
import ToastPanel from "../MComponents/MToastPanel";
import Loading from "../../loading/Loading";
import RulePanel from "../Panel/RulePanel";
import SignInPanel from "../Panel/SignInPanel";
import CommonPanel from "../Panel/CommonPanel";
import MTimer from "../MComponents/MTimer";
import { NetUtils } from "../Global/NetUtils";
import { MConst } from "../Global/MConst";
import { MConfigs } from "../Global/MConfigs";
import { MUtils } from "../Global/MUtils";

@Decorator.ClassName("StartScene")
export default class StartScene extends Scene {
    public btnStart: MButton;
    public btnRankList: MButton;
    public btnMustRead: MButton;
    public btnRule: MButton;
    public labelFreeTime: eui.Label;
    public btnSign: MButton;
    public btnBack: eui.Button;
    private leftTimes: number = null;
    private leftShareTimes: number = null;
    private btnShare: MButton;

    private

    onSkinComplete() {
        super.onSkinComplete();
        this.btnMustRead.visible = false;
        let div = document.getElementById("mainDiv");

        const test = (node: egret.DisplayObject, childIndex: number, color: string) => {
            if (node.$children[childIndex].y > 0) {
                div.style.background = color;
            }
            return node.$children[childIndex];
        }

        if (this.stage.y > 0) {
            div.style.background = "#00ff00";
        }
        let main = test(this.stage, 0, "#ff0000"); //Main
        let layers = test(main, 0, "#0000ff");//layers
        let sceneCtrl = test(layers, 0, "#ffff00"); //sceneCtrl
        let startScene = test(sceneCtrl, 0, "#ff00ff"); //startscene
        let bg = test(startScene.$children[0], 0, "#00ffff"); //bg

        this.btnRankList.onTap(this, () => {
            PanelCtrl.instance.show(RankListPanel, { defaultToggle: 1 });
        });

        // this.btnMustRead.image.filters = [new egret.ColorMatrixFilter([
        //     1, 1, 0, 0, 40,
        //     0, 0, 0, 0, 40,
        //     1, 0, 0, 0, 40,
        //     0, 0, 0, 1, 0
        // ])];

        this.btnRule.onTap(this, () => {
            PanelCtrl.instance.show(RulePanel, { msg: MConfigs.rule });
        });

        this.btnBack.onTap(this, () => {
            window.history.back();
        });

        this.btnShare.onOnceTap(this, (resume) => {
            window['share']();
            MTimer.set(120, () => {
                const timestamp = NetUtils.getTimestamp();
                Net.sendPost(Net.Url.share, {
                    timestamp: timestamp,
                    token: NetUtils.md5(timestamp + "duiba4icbc")
                }, () => {
                    ToastPanel.show("分享成功");
                    this.refreshPage();
                    resume();
                }, () => { resume(); });
            });
        });

        this.btnSign.onTap(this, () => {
            Net.sendGet(Net.Url.signData, undefined, (res) => {
                PanelCtrl.instance.show(SignInPanel, { response: res });
            });
        });

        // this.btnMustRead.onTap(this, () => {
        //     location.href = "http://activity.m.duiba.com.cn/customShare/share?id=3530";
        // });

        this.btnStart.onOnceTap(this, (resume) => {
            let leftTimes = this.leftTimes;
            if (typeof leftTimes == "number") {
                if (leftTimes > 0) { //有剩余次数
                    Net.sendPost(Net.Url.start, undefined, (res) => {
                        SceneCtrl.instance.change(MainScene, {
                            startId: res.data.startId,
                            maxScore: res.data.maxScore
                        });
                    }, () => { resume() });
                } else { //没有剩余次数
                    if (this.leftShareTimes > 0) { //有分享次数
                        let panel = PanelCtrl.instance.show<SharePanel>(SharePanel);
                        panel.init({
                            title: "次数已用完",
                            content: "分享好友可增加游戏机会哦~",
                            btnText: "分享好友"
                        });
                        panel.context = this;
                    } else { //没有分享次数
                        PanelCtrl.instance.show(class extends CommonPanel {
                            onSkinComplete() {
                                super.onSkinComplete();
                                this.btn.onTap(this, () => {
                                    this.hidePanel();
                                });
                            }
                        }, {
                            title: "今天次数已用完",
                            content: "明天再来吧~",
                            btnText: "知道了"
                        });
                    }
                    resume();
                }
            }
        });

        this.refreshPage();
    }

    public refreshPage() {
        Net.sendGet(Net.Url.visit, undefined, (res) => {
            GameMgr.instance.minEnableCaptchaScore = res.data.minEnableCaptchaScore;
            this.leftTimes = res.data.leftTimes;
            this.leftShareTimes = res.data.leftShareTimes;
            this.labelFreeTime.text = this.leftTimes <= 0 ? "今日暂无游戏次数" : `今日剩余次数：${this.leftTimes}次`;

            //判断是否需要弹签到弹窗
            Net.sendGet(Net.Url.signData, undefined, (res) => {
                if (!(res.data.todayPopSignFlag & 1 << 1)) { //没弹过弹窗
                    PanelCtrl.instance.show(SignInPanel, { response: res });
                }
            });
        }, () => { Loading.instace.show() });
    }
}

class SharePanel extends CommonPanel {
    context: StartScene = null;
    onSkinComplete() {
        super.onSkinComplete();
        this.btn.onOnceTap(this, (resume) => {
            window['share']();
            MTimer.set(120, () => {
                const timestamp = NetUtils.getTimestamp();
                Net.sendPost(Net.Url.share, {
                    timestamp: timestamp,
                    token: NetUtils.md5(timestamp + "duiba4icbc")
                }, () => {
                    ToastPanel.show("分享成功");
                    this.context.refreshPage();
                    resume();
                }, () => { resume(); });
            });
        });
    }
}